/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.SeCheck;
import org.sonar.javascript.se.points.BinaryProgramPoint;
import org.sonar.javascript.se.points.ProgramPoint;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;

@Rule(key="S3757")
public class ArithmeticOperationReturningNanCheck
extends SeCheck {
    private static final String MESSAGE = "Change the expression which uses this operand so that it can't evaluate to \"NaN\" (Not a Number).";
    private static final Constraint NUMBER_LIKE_OBJECT = Constraint.NUMBER_OBJECT.or(Constraint.BOOLEAN_OBJECT).or(Constraint.DATE);
    private static final Constraint UNDEFINED_OR_NON_NUMBER_OBJECT = Constraint.UNDEFINED.or(Constraint.OBJECT.and(NUMBER_LIKE_OBJECT.not()));
    private final Set<Symbol> symbolsWithIssues = new HashSet<Symbol>();
    private final Set<Tree> operandsWithIssues = new HashSet<Tree>();

    public void startOfExecution(Scope functionScope) {
        this.symbolsWithIssues.clear();
        super.startOfExecution(functionScope);
    }

    public void beforeBlockElement(ProgramState currentState, Tree element, ProgramPoint programPoint) {
        Constraint constraint;
        if (programPoint instanceof BinaryProgramPoint) {
            BinaryProgramPoint binaryPoint = (BinaryProgramPoint)programPoint;
            Constraint resultConstraint = binaryPoint.resultingConstraint(currentState);
            if (resultConstraint.isStricterOrEqualTo(Constraint.NAN)) {
                ExpressionComponents components = new ExpressionComponents(element);
                if (binaryPoint.firstOperandConstraint().isStricterOrEqualTo(UNDEFINED_OR_NON_NUMBER_OBJECT)) {
                    this.raiseIssue((Tree)components.leftOperand, new Tree[]{components.operator, components.rightOperand});
                } else {
                    this.raiseIssue((Tree)components.rightOperand, new Tree[]{components.operator, components.leftOperand});
                }
            }
        } else if (element.is(new Kinds[]{Tree.Kind.UNARY_PLUS, Tree.Kind.UNARY_MINUS, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT}) && (constraint = currentState.getConstraint(currentState.peekStack(0))).isStricterOrEqualTo(UNDEFINED_OR_NON_NUMBER_OBJECT)) {
            UnaryExpressionTree unaryExpression = (UnaryExpressionTree)element;
            this.raiseIssue((Tree)unaryExpression.expression(), new Tree[]{unaryExpression.operatorToken()});
        }
    }

    private void raiseIssue(Tree operand, Tree ... secondaryLocations) {
        Symbol operandSymbol = null;
        if (operand.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
            IdentifierTree identifier = (IdentifierTree)operand;
            operandSymbol = identifier.symbol().orElse(null);
        }
        if (!this.symbolsWithIssues.contains(operandSymbol) && !this.operandsWithIssues.contains(operand)) {
            PreciseIssue issue = this.addIssue(operand, MESSAGE);
            Arrays.asList(secondaryLocations).forEach(arg_0 -> ((PreciseIssue)issue).secondary(arg_0));
            if (operandSymbol != null) {
                this.symbolsWithIssues.add(operandSymbol);
            }
            this.operandsWithIssues.add(operand);
        }
    }

    private static class ExpressionComponents {
        private ExpressionTree leftOperand;
        private ExpressionTree rightOperand;
        private Tree operator;

        public ExpressionComponents(Tree element) {
            if (element instanceof AssignmentExpressionTree) {
                AssignmentExpressionTree assignment = (AssignmentExpressionTree)element;
                this.leftOperand = assignment.variable();
                this.rightOperand = assignment.expression();
                this.operator = assignment.operatorToken();
            } else {
                BinaryExpressionTree binaryExpression = (BinaryExpressionTree)element;
                this.leftOperand = binaryExpression.leftOperand();
                this.rightOperand = binaryExpression.rightOperand();
                this.operator = binaryExpression.operatorToken();
            }
        }
    }
}

