/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.typed.ActionParser;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.javascript.parser.JavaScriptParserBuilder;
import org.sonar.javascript.tree.JavaScriptCommentAnalyser;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.ModuleTree;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ThrowStatementTree;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="CommentedCode")
public class CommentedCodeCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Remove this commented out code.";
    private static final JavaScriptCommentAnalyser COMMENT_ANALYSER = new JavaScriptCommentAnalyser();
    private static final ActionParser<Tree> PARSER = JavaScriptParserBuilder.createParser();

    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.of((Object)Tree.Kind.TOKEN);
    }

    public void visitNode(Tree tree) {
        List<List<SyntaxTrivia>> commentGroups = CommentedCodeCheck.groupComments((SyntaxToken)tree);
        commentGroups.forEach(this::checkCommentGroup);
    }

    private void checkCommentGroup(List<SyntaxTrivia> commentGroup) {
        String uncommentedText = CommentedCodeCheck.uncomment(commentGroup);
        if (CommentedCodeCheck.isRawExclusion(uncommentedText)) {
            return;
        }
        uncommentedText = CommentedCodeCheck.injectMissingBraces(uncommentedText);
        try {
            ScriptTree parsedUncommentedText = (ScriptTree)PARSER.parse(uncommentedText);
            if (CommentedCodeCheck.isExclusion(parsedUncommentedText)) {
                return;
            }
            IssueLocation primaryLocation = new IssueLocation((Tree)commentGroup.get(0), (Tree)commentGroup.get(commentGroup.size() - 1), MESSAGE);
            this.addIssue((Issue)new PreciseIssue((JavaScriptCheck)this, primaryLocation));
        }
        catch (RecognitionException recognitionException) {
            // empty catch block
        }
    }

    private static boolean isRawExclusion(String uncommentedText) {
        return uncommentedText.trim().matches("}");
    }

    private static String injectMissingBraces(String uncommentedText) {
        int i;
        StringBuilder toParse = new StringBuilder(uncommentedText);
        int openCurlyBraceNum = StringUtils.countMatches((String)uncommentedText, (String)"{");
        int closeCurlyBraceNum = StringUtils.countMatches((String)uncommentedText, (String)"}");
        int missingBraces = openCurlyBraceNum - closeCurlyBraceNum;
        for (i = 0; i < missingBraces; ++i) {
            toParse.append("}");
        }
        for (i = missingBraces; i < 0; ++i) {
            toParse.insert(0, "{");
        }
        return toParse.toString();
    }

    private static String uncomment(List<SyntaxTrivia> triviaGroup) {
        StringBuilder uncommentedText = new StringBuilder();
        for (SyntaxTrivia trivia : triviaGroup) {
            String value = COMMENT_ANALYSER.getContents(trivia.text());
            uncommentedText.append("\n");
            uncommentedText.append(value);
        }
        return uncommentedText.toString().trim();
    }

    private static boolean isExclusion(ScriptTree scriptTree) {
        Tree statement;
        ModuleTree scriptContent = scriptTree.items();
        if (scriptContent == null) {
            return true;
        }
        return scriptContent.items().size() == 1 && ((statement = (Tree)scriptContent.items().get(0)).is(new Kinds[]{Tree.Kind.LABELLED_STATEMENT, Tree.Kind.BREAK_STATEMENT, Tree.Kind.CONTINUE_STATEMENT}) || CommentedCodeCheck.isExpressionExclusion(statement) || CommentedCodeCheck.isReturnThrowExclusion(statement));
    }

    private static boolean isReturnThrowExclusion(Tree item) {
        ExpressionTree expression = null;
        if (item.is(new Kinds[]{Tree.Kind.RETURN_STATEMENT})) {
            expression = ((ReturnStatementTree)item).expression();
        } else if (item.is(new Kinds[]{Tree.Kind.THROW_STATEMENT})) {
            expression = ((ThrowStatementTree)item).expression();
        }
        return expression != null && expression.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE});
    }

    private static boolean isExpressionExclusion(Tree item) {
        ExpressionStatementTree expressionStatement;
        return item.is(new Kinds[]{Tree.Kind.EXPRESSION_STATEMENT}) && ((expressionStatement = (ExpressionStatementTree)item).expression().is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE, Tree.Kind.UNARY_PLUS, Tree.Kind.UNARY_MINUS, Tree.Kind.STRING_LITERAL}) || expressionStatement.semicolonToken() == null || expressionStatement.expression().is(new Kinds[]{Tree.Kind.COMMA_OPERATOR}));
    }

    private static List<List<SyntaxTrivia>> groupComments(SyntaxToken token) {
        LinkedList<List<SyntaxTrivia>> groups = new LinkedList<List<SyntaxTrivia>>();
        List<SyntaxTrivia> currentGroup = null;
        for (SyntaxTrivia trivia : token.trivias()) {
            if (CommentedCodeCheck.isJsDoc(trivia) || CommentedCodeCheck.isJsLint(trivia) || CommentedCodeCheck.isJsHint(trivia) || CommentedCodeCheck.isGlobals(trivia)) continue;
            if (currentGroup == null) {
                currentGroup = CommentedCodeCheck.initNewGroup(trivia);
                continue;
            }
            if (CommentedCodeCheck.isAdjacent(trivia, currentGroup)) {
                currentGroup.add(trivia);
                continue;
            }
            groups.add(currentGroup);
            currentGroup = CommentedCodeCheck.initNewGroup(trivia);
        }
        if (currentGroup != null) {
            groups.add(currentGroup);
        }
        return groups;
    }

    private static List<SyntaxTrivia> initNewGroup(SyntaxTrivia trivia) {
        LinkedList<SyntaxTrivia> group = new LinkedList<SyntaxTrivia>();
        group.add(trivia);
        return group;
    }

    private static boolean isAdjacent(SyntaxTrivia trivia, List<SyntaxTrivia> currentGroup) {
        return currentGroup.get(currentGroup.size() - 1).line() + 1 == trivia.line();
    }

    private static boolean isJsDoc(SyntaxTrivia trivia) {
        return trivia.text().startsWith("/**");
    }

    private static boolean isJsLint(SyntaxTrivia trivia) {
        return trivia.text().startsWith("/*jslint");
    }

    private static boolean isJsHint(SyntaxTrivia trivia) {
        return trivia.text().startsWith("/*jshint");
    }

    private static boolean isGlobals(SyntaxTrivia trivia) {
        return trivia.text().startsWith("/*global");
    }
}

