/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="ConditionalComment")
public class ConditionalCommentCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Refactor your code to avoid using Internet Explorer's conditional comments.";

    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.of((Object)Tree.Kind.TOKEN);
    }

    public void visitNode(Tree tree) {
        SyntaxToken token = (SyntaxToken)tree;
        for (SyntaxTrivia trivia : token.trivias()) {
            String comment = trivia.text();
            if (!comment.startsWith("/*@cc_on") && !comment.startsWith("//@cc_on")) continue;
            this.addIssue((Tree)trivia, MESSAGE);
        }
    }
}

