/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractAlwaysTrueOrFalseConditionCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;

@Rule(key="S2583")
public class ConditionalUnreachableCodeCheck
extends AbstractAlwaysTrueOrFalseConditionCheck {
    private static final String MESSAGE = "Change this condition so that it does not always evaluate to \"%s\"; some subsequent code is never executed.";

    @Override
    protected void conditionWithDeadCode(Tree condition, boolean isTruthy, Set<Tree> deadCode) {
        String result = isTruthy ? "true" : "false";
        PreciseIssue preciseIssue = this.addIssue(condition, String.format(MESSAGE, result));
        deadCode.forEach(deadCodeTree -> preciseIssue.secondary(deadCodeTree, "Never reached"));
    }
}

