/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S2757")
public class NonExistentAssignmentOperatorCheck
extends SubscriptionVisitorCheck {
    private static final String PLUS_MESSAGE = "Was \"+=\" meant instead?";
    private static final String MINUS_MESSAGE = "Was \"-=\" meant instead?";

    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.of((Object)Tree.Kind.ASSIGNMENT);
    }

    public void visitNode(Tree tree) {
        AssignmentExpressionTree assignment = (AssignmentExpressionTree)tree;
        ExpressionTree expression = assignment.expression();
        if (expression.is(new Kinds[]{Tree.Kind.UNARY_PLUS, Tree.Kind.UNARY_MINUS})) {
            SyntaxToken expressionOperator;
            UnaryExpressionTree unaryExpression = (UnaryExpressionTree)expression;
            SyntaxToken assignmentOperator = assignment.operatorToken();
            if (NonExistentAssignmentOperatorCheck.areAdjacent((Tree)assignmentOperator, (Tree)(expressionOperator = unaryExpression.operatorToken())) && !NonExistentAssignmentOperatorCheck.areAdjacent((Tree)expressionOperator, (Tree)unaryExpression.expression())) {
                String message = expression.is(new Kinds[]{Tree.Kind.UNARY_PLUS}) ? PLUS_MESSAGE : MINUS_MESSAGE;
                this.addIssue((Issue)new PreciseIssue((JavaScriptCheck)this, new IssueLocation((Tree)assignmentOperator, (Tree)expressionOperator, message)));
            }
        }
        super.visitNode(tree);
    }

    private static boolean areAdjacent(Tree tree1, Tree tree2) {
        SyntaxToken tree1LastToken = tree1.lastToken();
        SyntaxToken tree2FirstToken = tree2.firstToken();
        return tree1LastToken.endColumn() == tree2FirstToken.column() && tree1LastToken.endLine() == tree2FirstToken.line();
    }
}

