/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ArgumentListTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="PrimitiveWrappers")
public class PrimitiveWrappersCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Use a literal value for this.";
    private static final Map<String, Tree.Kind> ALLOWED_ARGUMENT_PER_WRAPPER = ImmutableMap.of((Object)"Boolean", (Object)Tree.Kind.BOOLEAN_LITERAL, (Object)"Number", (Object)Tree.Kind.NUMERIC_LITERAL, (Object)"String", (Object)Tree.Kind.STRING_LITERAL);

    public void visitNewExpression(NewExpressionTree tree) {
        Tree.Kind allowedArgument;
        ExpressionTree constructor = tree.expression();
        ArgumentListTree arguments = tree.argumentClause();
        if (constructor.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE}) && (allowedArgument = ALLOWED_ARGUMENT_PER_WRAPPER.get(((IdentifierTree)constructor).name())) != null && !PrimitiveWrappersCheck.isAllowedUsage(arguments, allowedArgument)) {
            this.addIssue((Tree)tree, MESSAGE);
        }
        super.visitNewExpression(tree);
    }

    private static boolean isAllowedUsage(@Nullable ArgumentListTree arguments, Tree.Kind allowedArgument) {
        Tree argument;
        if (arguments != null && arguments.arguments().size() == 1 && (argument = (Tree)arguments.arguments().get(0)).is(new Kinds[]{allowedArgument})) {
            return !"false".equals(((LiteralTree)argument).value());
        }
        return false;
    }
}

