/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.javascript.api.tree.statement.ForObjectStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableDeclarationTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S1226")
public class ReassignedParameterCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Introduce a new variable instead of reusing the %s \"%s\".";
    private static final String FOREACH_VARIABLE = "foreach variable";
    private static final String PARAMETER = "parameter";
    private static final String CAUGHT_EXCEPTION = "caught exception";

    public void visitNode(Tree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.CATCH_BLOCK})) {
            this.checkBindingElement((BindingElementTree)((CatchBlockTree)tree).parameter(), CAUGHT_EXCEPTION);
        } else if (tree.is(new Kinds[]{Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_OF_STATEMENT})) {
            this.checkForLoop((ForObjectStatementTree)tree);
        } else {
            this.checkFunctionParameters((FunctionTree)tree);
        }
    }

    private void checkFunctionParameters(FunctionTree functionTree) {
        Tree parameterClause = functionTree.parameterClause();
        if (parameterClause.is(new Kinds[]{Tree.Kind.BINDING_IDENTIFIER})) {
            this.checkBindingElement((BindingElementTree)((IdentifierTree)parameterClause), PARAMETER);
        } else {
            for (Tree parameterTree : ((ParameterListTree)parameterClause).parameters()) {
                this.checkBindingElement((BindingElementTree)parameterTree, PARAMETER);
            }
        }
    }

    private void checkForLoop(ForObjectStatementTree forLoop) {
        Tree variableOrExpression = forLoop.variableOrExpression();
        if (variableOrExpression instanceof VariableDeclarationTree) {
            for (BindingElementTree bindingElementTree : ((VariableDeclarationTree)variableOrExpression).variables()) {
                this.checkBindingElement(bindingElementTree, FOREACH_VARIABLE);
            }
        } else if (variableOrExpression.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
            IdentifierTree identifier = (IdentifierTree)variableOrExpression;
            identifier.symbol().ifPresent(s -> this.checkSymbol((Symbol)s, identifier, forLoop, FOREACH_VARIABLE));
        }
    }

    private void checkBindingElement(BindingElementTree parameter, String title) {
        for (IdentifierTree identifierTree : parameter.bindingIdentifiers()) {
            identifierTree.symbol().ifPresent(s -> this.checkSymbol((Symbol)s, identifierTree, null, title));
        }
    }

    private void checkSymbol(Symbol symbol, IdentifierTree declarationIdentifier, @Nullable ForObjectStatementTree loop, String title) {
        for (Usage usage : symbol.usages()) {
            if (!usage.isWrite() || usage.identifierTree().equals(declarationIdentifier) || loop != null && !CheckUtils.isDescendant((Tree)usage.identifierTree(), (Tree)loop)) continue;
            this.addIssue((Tree)usage.identifierTree(), String.format(MESSAGE, title, symbol.name()));
        }
    }

    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.builder().addAll((Iterable)KindSet.FUNCTION_KINDS.getSubKinds()).add((Object)Tree.Kind.CATCH_BLOCK).add((Object)Tree.Kind.FOR_IN_STATEMENT).add((Object)Tree.Kind.FOR_OF_STATEMENT).build();
    }
}

