/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.JavaScriptFile;
import org.sonar.plugins.javascript.api.visitors.LineIssue;

@Rule(key="TabCharacter")
public class TabCharacterCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Replace all tab characters in this file by sequences of white-spaces.";

    public void visitScript(ScriptTree tree) {
        JavaScriptFile javaScriptFile = this.getContext().getJavaScriptFile();
        List<String> lines = CheckUtils.readLines(javaScriptFile);
        for (int i = 0; i < lines.size(); ++i) {
            if (!lines.get(i).contains("\t")) continue;
            this.addIssue((Issue)new LineIssue((JavaScriptCheck)this, i + 1, MESSAGE));
            break;
        }
    }
}

