/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractAllPathSeCheck;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.FunctionWithTreeSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ConditionalExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitor;

@Rule(key="S3699")
public class UseOfEmptyReturnValueCheck
extends AbstractAllPathSeCheck<CallExpressionTree> {
    private static final String MESSAGE = "Remove this use of the output from %s; %s doesn't return anything.";

    @Override
    CallExpressionTree getTree(Tree element) {
        Tree parent = element.parent();
        if (element.is(new Kinds[]{Tree.Kind.CALL_EXPRESSION}) && !parent.is(new Kinds[]{Tree.Kind.RETURN_STATEMENT, Tree.Kind.AWAIT}) && !UseOfEmptyReturnValueCheck.isModulePattern((CallExpressionTree)element)) {
            return (CallExpressionTree)element;
        }
        return null;
    }

    private static boolean isModulePattern(CallExpressionTree callExpression) {
        Tree parent = callExpression.parent();
        return callExpression.callee().is(new Kinds[]{KindSet.FUNCTION_KINDS}) && parent.is(new Kinds[]{Tree.Kind.PARENTHESISED_EXPRESSION, Tree.Kind.LOGICAL_COMPLEMENT}) && parent.parent().is(new Kinds[]{Tree.Kind.EXPRESSION_STATEMENT});
    }

    @Override
    boolean isProblem(CallExpressionTree tree, ProgramState currentState) {
        FunctionTree functionTree = UseOfEmptyReturnValueCheck.functionTree(tree, currentState);
        return functionTree != null && !UseOfEmptyReturnValueCheck.hasReturnValue(functionTree) && UseOfEmptyReturnValueCheck.isReturnValueUsed(tree);
    }

    private static boolean hasReturnValue(FunctionTree functionTree) {
        return ReturnVisitor.hasReturnValue(functionTree);
    }

    private static boolean isReturnValueUsed(CallExpressionTree tree) {
        Tree parent = UseOfEmptyReturnValueCheck.getParentIgnoreParenthesis((Tree)tree);
        if (parent.is(new Kinds[]{Tree.Kind.CONDITIONAL_OR, Tree.Kind.CONDITIONAL_AND})) {
            return ((BinaryExpressionTree)parent).leftOperand().equals(tree);
        }
        if (parent.is(new Kinds[]{Tree.Kind.CONDITIONAL_EXPRESSION})) {
            return ((ConditionalExpressionTree)parent).condition().equals(tree);
        }
        return !parent.is(new Kinds[]{Tree.Kind.EXPRESSION_STATEMENT});
    }

    @CheckForNull
    private static FunctionTree functionTree(CallExpressionTree tree, ProgramState currentState) {
        SymbolicValue calleeSV = currentState.peekStack(tree.argumentClause().arguments().size());
        if (calleeSV instanceof FunctionWithTreeSymbolicValue) {
            return ((FunctionWithTreeSymbolicValue)calleeSV).getFunctionTree();
        }
        return null;
    }

    @Override
    void raiseIssue(CallExpressionTree tree) {
        String functionName = "this function";
        if (tree.callee().is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
            functionName = "\"" + ((IdentifierTree)tree.callee()).name() + "\"";
        }
        this.addIssue((Tree)tree.callee(), String.format(MESSAGE, functionName, functionName));
    }

    private static Tree getParentIgnoreParenthesis(Tree tree) {
        Tree parent = tree.parent();
        if (parent.is(new Kinds[]{Tree.Kind.PARENTHESISED_EXPRESSION})) {
            return UseOfEmptyReturnValueCheck.getParentIgnoreParenthesis(parent);
        }
        return parent;
    }

    private static class ReturnVisitor
    extends SubscriptionVisitor {
        boolean hasReturnValue = false;
        int nestingLevel = 0;

        private ReturnVisitor() {
        }

        public Set<Tree.Kind> nodesToVisit() {
            return ImmutableSet.builder().addAll((Iterable)KindSet.FUNCTION_KINDS.getSubKinds()).add((Object)Tree.Kind.RETURN_STATEMENT).build();
        }

        private static boolean hasReturnValue(FunctionTree tree) {
            if (tree.is(new Kinds[]{Tree.Kind.ARROW_FUNCTION})) {
                ArrowFunctionTree arrowFunction = (ArrowFunctionTree)tree;
                if (!arrowFunction.body().is(new Kinds[]{Tree.Kind.BLOCK})) {
                    return true;
                }
            }
            ReturnVisitor returnVisitor = new ReturnVisitor();
            returnVisitor.scanTree(tree.body());
            return returnVisitor.hasReturnValue;
        }

        public void visitNode(Tree tree) {
            if (tree.is(new Kinds[]{Tree.Kind.RETURN_STATEMENT})) {
                ReturnStatementTree returnStatement = (ReturnStatementTree)tree;
                if (returnStatement.expression() != null && this.nestingLevel == 0) {
                    this.hasReturnValue = true;
                }
            } else {
                ++this.nestingLevel;
            }
        }

        public void leaveNode(Tree tree) {
            if (!tree.is(new Kinds[]{Tree.Kind.RETURN_STATEMENT})) {
                --this.nestingLevel;
            }
        }
    }
}

