/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractAnyPathSeCheck;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.points.ProgramPoint;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;

@Rule(key="S4043")
public class ArrayReverseCheck
extends AbstractAnyPathSeCheck {
    private static final String REVERSE = "reverse";
    private static final String MESSAGE = "Move this array \"reverse\" operation to a separate statement.";

    public void beforeBlockElement(ProgramState currentState, Tree element, ProgramPoint programPoint) {
        if (element.is(new Kinds[]{Tree.Kind.CALL_EXPRESSION})) {
            CallExpressionTree callExpression = (CallExpressionTree)element;
            if (callExpression.callee().is(new Kinds[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
                MemberExpressionTree memberExpression = (MemberExpressionTree)callExpression.callee();
                this.checkMemberExpression(currentState, callExpression, memberExpression);
            }
        }
    }

    private void checkMemberExpression(ProgramState currentState, CallExpressionTree callExpression, MemberExpressionTree memberExpression) {
        ExpressionTree object = memberExpression.object();
        if (!ArrayReverseCheck.isReverseMethod(memberExpression.property()) || !object.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
            return;
        }
        ((IdentifierTree)object).symbol().ifPresent(objectSymbol -> {
            if (ArrayReverseCheck.isArray(objectSymbol, currentState) && ArrayReverseCheck.isBeingPassedElsewhere(objectSymbol, (Tree)callExpression)) {
                this.addUniqueIssue((Tree)callExpression, MESSAGE);
            }
        });
    }

    private static boolean isBeingPassedElsewhere(Symbol objectSymbol, Tree element) {
        AssignmentExpressionTree assignment;
        if (element.parent().is(new Kinds[]{Tree.Kind.ASSIGNMENT}) && (assignment = (AssignmentExpressionTree)element.parent()).variable().is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
            IdentifierTree identifier = (IdentifierTree)assignment.variable();
            return !ArrayReverseCheck.sameSymbol(objectSymbol, identifier);
        }
        return element.parent().is(new Kinds[]{Tree.Kind.ARGUMENT_LIST, Tree.Kind.INITIALIZED_BINDING_ELEMENT});
    }

    private static boolean sameSymbol(Symbol objectSymbol, IdentifierTree lastIdentifier) {
        Optional bindingSymbol = lastIdentifier.symbol();
        return bindingSymbol.map(symbol -> symbol.equals(objectSymbol)).orElse(false);
    }

    private static boolean isArray(Symbol symbol, ProgramState currentState) {
        return currentState.getConstraint(symbol).isStricterOrEqualTo(Constraint.ARRAY);
    }

    private static boolean isReverseMethod(ExpressionTree property) {
        IdentifierTree propertyIdentifier;
        return property.is(new Kinds[]{Tree.Kind.PROPERTY_IDENTIFIER}) && REVERSE.equals((propertyIdentifier = (IdentifierTree)property).name());
    }
}

