/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.EnumSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S3798")
public class DeclarationInGlobalScopeCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Define this declaration in a local scope or bind explicitly the property to the global object.";
    private static Set<Symbol.Kind> kindsNotToBeChecked = EnumSet.of(Symbol.Kind.CONST_VARIABLE, Symbol.Kind.LET_VARIABLE, Symbol.Kind.CLASS, Symbol.Kind.IMPORT);

    public void visitScript(ScriptTree tree) {
        for (Symbol symbol : this.getContext().getSymbolModel().getSymbols()) {
            if (!symbol.scope().isGlobal() || kindsNotToBeChecked.contains(symbol.kind()) || symbol.external()) continue;
            this.checkSymbol(symbol);
        }
    }

    private void checkSymbol(Symbol symbol) {
        for (Usage usage : symbol.usages()) {
            if (!usage.isDeclaration()) continue;
            this.addIssue((Tree)usage.identifierTree(), MESSAGE);
            return;
        }
    }
}

