/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.HashSet;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractDuplicateBranchImplementationCheck;
import org.sonar.javascript.metrics.LineVisitor;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchClauseTree;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;

@Rule(key="S1871")
public class DuplicateBranchImplementationCheck
extends AbstractDuplicateBranchImplementationCheck {
    private static final String MESSAGE = "Either merge this %s with the identical one on line \"%s\" or change one of the implementations.";

    @Override
    protected void checkDuplicatedBranches(List<Tree> branches) {
        HashSet<Tree> withIssue = new HashSet<Tree>();
        for (int i = 0; i < branches.size(); ++i) {
            Tree currentBranch = branches.get(i);
            for (int j = i + 1; j < branches.size(); ++j) {
                Tree comparedBranch = branches.get(j);
                if (withIssue.contains(comparedBranch) || !DuplicateBranchImplementationCheck.syntacticallyEqual(currentBranch, comparedBranch) || DuplicateBranchImplementationCheck.linesOfCodeForBranch(comparedBranch) <= 1) continue;
                IssueLocation secondary = new IssueLocation(currentBranch, "Original");
                String branchType = currentBranch instanceof SwitchClauseTree ? "case" : "branch";
                String message = String.format(MESSAGE, branchType, secondary.startLine());
                this.addIssue(comparedBranch, message).secondary(secondary);
                withIssue.add(comparedBranch);
            }
        }
    }

    @Override
    protected void allBranchesDuplicated(Tree tree) {
    }

    private static <T> int linesOfCodeForBranch(T branch) {
        if (branch instanceof SwitchClauseTree) {
            return new LineVisitor(DuplicateBranchImplementationCheck.normalize((SwitchClauseTree)branch)).getLinesOfCodeNumber();
        }
        StatementTree statementBranch = (StatementTree)branch;
        LineVisitor lineVisitor = statementBranch.is(new Kinds[]{Tree.Kind.BLOCK}) ? new LineVisitor(((BlockTree)statementBranch).statements()) : new LineVisitor((Tree)statementBranch);
        return lineVisitor.getLinesOfCodeNumber();
    }
}

