/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.metrics.ComplexityVisitor;
import org.sonar.javascript.metrics.FunctionDefiningModuleVisitor;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="FunctionComplexity")
public class FunctionComplexityCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Function has a complexity of %s which is greater than %s authorized.";
    private static final int DEFAULT_MAXIMUM_FUNCTION_COMPLEXITY_THRESHOLD = 10;
    @RuleProperty(key="maximumFunctionComplexityThreshold", description="The maximum authorized complexity in function", defaultValue="10")
    private int maximumFunctionComplexityThreshold = 10;
    private Set<FunctionTree> functionsDefiningModuleCurrentScript = new HashSet<FunctionTree>();

    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.builder().addAll((Iterable)KindSet.FUNCTION_KINDS.getSubKinds()).add((Object)Tree.Kind.SCRIPT).build();
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.SCRIPT})) {
            this.functionsDefiningModuleCurrentScript = FunctionDefiningModuleVisitor.getFunctionsDefiningModule((ScriptTree)((ScriptTree)tree));
        } else if (!this.functionsDefiningModuleCurrentScript.contains(tree)) {
            this.checkFunction((FunctionTree)tree);
        }
    }

    private void checkFunction(FunctionTree functionTree) {
        List complexityTrees = new ComplexityVisitor(false).complexityTrees((Tree)functionTree);
        if (complexityTrees.size() > this.maximumFunctionComplexityThreshold) {
            this.raiseIssue(functionTree, complexityTrees);
        }
    }

    private void raiseIssue(FunctionTree tree, List<Tree> complexityTrees) {
        int complexity = complexityTrees.size();
        String message = String.format(MESSAGE, complexity, this.maximumFunctionComplexityThreshold);
        IssueLocation primaryIssueLocation = new IssueLocation((Tree)tree.firstToken(), tree.parameterClause(), message);
        PreciseIssue issue = (PreciseIssue)this.addIssue((Issue)new PreciseIssue((JavaScriptCheck)this, primaryIssueLocation));
        for (Tree complexityTree : complexityTrees) {
            issue.secondary(complexityTree, "+1");
        }
        issue.cost((double)complexity - (double)this.maximumFunctionComplexityThreshold);
    }

    public void setMaximumFunctionComplexityThreshold(int threshold) {
        this.maximumFunctionComplexityThreshold = threshold;
    }
}

