/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.SeCheck;
import org.sonar.javascript.se.points.MemberProgramPoint;
import org.sonar.javascript.se.points.ProgramPoint;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.ForObjectStatementTree;

@Rule(key="S2259")
public class NullDereferenceCheck
extends SeCheck {
    private static final String MESSAGE = "TypeError can be thrown as \"%s\" might be null or undefined here.";
    private static final String EXPRESSION_MESSAGE = "TypeError can be thrown as this expression might be null or undefined here.";
    private Set<Symbol> hasIssue;

    public void startOfExecution(Scope functionScope) {
        this.hasIssue = new HashSet<Symbol>();
    }

    public void beforeBlockElement(ProgramState currentState, Tree element, ProgramPoint programPoint) {
        Symbol symbol;
        if (programPoint instanceof MemberProgramPoint) {
            Optional result = programPoint.execute(currentState);
            if (!result.isPresent()) {
                ExpressionTree memberOwner = ((MemberExpressionTree)element).object();
                Symbol symbol2 = NullDereferenceCheck.getSymbol(memberOwner);
                this.addUniqueIssue((Tree)memberOwner, symbol2);
            }
        } else if (NullDereferenceCheck.isForOfExpression(element) && currentState.getConstraint(symbol = NullDereferenceCheck.getSymbol((ExpressionTree)element)).isStricterOrEqualTo(Constraint.NULL_OR_UNDEFINED)) {
            this.addUniqueIssue(element, symbol);
        }
    }

    private void addUniqueIssue(Tree tree, @Nullable Symbol symbol) {
        if (symbol == null) {
            this.addIssue(tree, EXPRESSION_MESSAGE);
        } else if (!this.hasIssue.contains(symbol)) {
            this.addIssue(tree, String.format(MESSAGE, symbol.name()));
            this.hasIssue.add(symbol);
        }
    }

    @Nullable
    private static Symbol getSymbol(ExpressionTree object) {
        if (object.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
            return ((IdentifierTree)object).symbol().orElse(null);
        }
        return null;
    }

    private static boolean isForOfExpression(Tree element) {
        Tree parent = element.parent();
        return parent.is(new Kinds[]{Tree.Kind.FOR_OF_STATEMENT}) && element.equals(((ForObjectStatementTree)parent).expression());
    }
}

