/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IterationStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="OneStatementPerLine")
public class OneStatementPerLineCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Reformat the code to have only one statement per line.";
    private ListMultimap<Integer, StatementTree> statementsPerLine = ArrayListMultimap.create();
    private List<StatementTree> excludedStatements = new ArrayList<StatementTree>();

    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.of((Object)Tree.Kind.VARIABLE_STATEMENT, (Object)Tree.Kind.EXPRESSION_STATEMENT, (Object)Tree.Kind.IF_STATEMENT, (Object)Tree.Kind.DO_WHILE_STATEMENT, (Object)Tree.Kind.WHILE_STATEMENT, (Object)Tree.Kind.FOR_IN_STATEMENT, (Object[])new Tree.Kind[]{Tree.Kind.FOR_OF_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.CONTINUE_STATEMENT, Tree.Kind.BREAK_STATEMENT, Tree.Kind.RETURN_STATEMENT, Tree.Kind.WITH_STATEMENT, Tree.Kind.SWITCH_STATEMENT, Tree.Kind.THROW_STATEMENT, Tree.Kind.TRY_STATEMENT, Tree.Kind.DEBUGGER_STATEMENT, Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, Tree.Kind.ARROW_FUNCTION, Tree.Kind.SCRIPT});
    }

    public void visitFile(Tree scriptTree) {
        this.statementsPerLine.clear();
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.IF_STATEMENT})) {
            this.checkForExcludedStatement(((IfStatementTree)tree).statement(), tree);
        }
        if (tree.is(new Kinds[]{KindSet.LOOP_KINDS})) {
            this.checkForExcludedStatement(((IterationStatementTree)tree).statement(), tree);
        }
        if (tree.is(new Kinds[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, Tree.Kind.ARROW_FUNCTION})) {
            this.checkFunctionException((FunctionTree)tree);
        }
        if (!tree.is(new Kinds[]{Tree.Kind.SCRIPT, Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, Tree.Kind.ARROW_FUNCTION}) && !this.excludedStatements.contains(tree)) {
            this.statementsPerLine.put((Object)tree.firstToken().line(), (Object)((StatementTree)tree));
        }
    }

    private void checkForExcludedStatement(StatementTree nestedStatement, Tree statement) {
        int statementLine = statement.firstToken().line();
        if (nestedStatement.is(new Kinds[]{Tree.Kind.BLOCK})) {
            BlockTree blockTree = (BlockTree)nestedStatement;
            if (blockTree.closeCurlyBraceToken().line() == statementLine && blockTree.statements().size() == 1) {
                this.excludedStatements.add((StatementTree)blockTree.statements().get(0));
            }
        } else {
            int nestedStatementLine = nestedStatement.firstToken().line();
            if (nestedStatementLine == statementLine) {
                this.excludedStatements.add(nestedStatement);
            }
        }
    }

    private void checkFunctionException(FunctionTree functionTree) {
        if (!functionTree.body().is(new Kinds[]{Tree.Kind.BLOCK})) {
            return;
        }
        int line = functionTree.firstToken().line();
        List statements = ((BlockTree)functionTree.body()).statements();
        if (statements.size() == 1 && ((StatementTree)statements.get(0)).firstToken().line() == line && this.statementsPerLine.containsKey((Object)line)) {
            this.excludedStatements.add((StatementTree)statements.get(0));
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.SCRIPT})) {
            Iterator iterator = this.statementsPerLine.keys().elementSet().iterator();
            while (iterator.hasNext()) {
                int line = (Integer)iterator.next();
                List statementsAtLine = this.statementsPerLine.get((Object)line);
                if (statementsAtLine.size() <= 1) continue;
                this.addIssue(statementsAtLine);
            }
            this.excludedStatements.clear();
        }
    }

    private void addIssue(List<StatementTree> statementsAtLine) {
        PreciseIssue issue = this.addIssue((Tree)statementsAtLine.get(1), MESSAGE);
        for (int i = 2; i < statementsAtLine.size(); ++i) {
            issue.secondary(new IssueLocation((Tree)statementsAtLine.get(i)));
        }
    }
}

