/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.WithStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;

@Rule(key="S3827")
public class ReferenceErrorCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "\"%s\" does not exist. Change its name or declare it so that its usage doesn't result in a \"ReferenceError\".";
    private final ListMultimap<String, IdentifierTree> undeclaredIdentifiersByName = ArrayListMultimap.create();
    private final Set<String> excludedNames = new HashSet<String>();

    public void visitScript(ScriptTree tree) {
        this.undeclaredIdentifiersByName.clear();
        this.excludedNames.clear();
        super.visitScript(tree);
        for (String name : this.undeclaredIdentifiersByName.keySet()) {
            List identifiers = this.undeclaredIdentifiersByName.get((Object)name);
            PreciseIssue issue = this.addIssue((Tree)identifiers.get(0), String.format(MESSAGE, name));
            identifiers.subList(1, identifiers.size()).stream().forEach(arg_0 -> ((PreciseIssue)issue).secondary(arg_0));
        }
    }

    public void visitIdentifier(IdentifierTree identifier) {
        if (identifier.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE}) && !identifier.symbol().isPresent() && !"undefined".equals(identifier.name()) && !this.excludedNames.contains(identifier.name())) {
            this.undeclaredIdentifiersByName.put((Object)identifier.name(), (Object)identifier);
        }
        super.visitIdentifier(identifier);
    }

    public void visitWithStatement(WithStatementTree tree) {
    }

    public void visitUnaryExpression(UnaryExpressionTree unaryExpression) {
        if (unaryExpression.is(new Kinds[]{Tree.Kind.TYPEOF})) {
            ExpressionTree expression = unaryExpression.expression();
            if (expression.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
                this.excludedNames.add(((IdentifierTree)expression).name());
            }
        }
        super.visitUnaryExpression(unaryExpression);
    }
}

