/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.JavaScriptFile;
import org.sonar.plugins.javascript.api.visitors.LineIssue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="TrailingWhitespace")
public class TrailingWhitespaceCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Remove the useless trailing whitespaces at the end of this line.";

    public Set<Tree.Kind> nodesToVisit() {
        return Collections.emptySet();
    }

    public void visitFile(Tree scriptTree) {
        JavaScriptFile javaScriptFile = this.getContext().getJavaScriptFile();
        List<String> lines = CheckUtils.readLines(javaScriptFile);
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (line.length() <= 0 || !Pattern.matches("[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]", line.subSequence(line.length() - 1, line.length()))) continue;
            this.addIssue((Issue)new LineIssue((JavaScriptCheck)this, i + 1, MESSAGE));
        }
    }
}

