/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.SeCheck;
import org.sonar.javascript.tree.KindSet;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ConditionalExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.statement.ConditionalTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IterationStatementTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitor;

public abstract class AbstractAlwaysTrueOrFalseConditionCheck
extends SeCheck {
    private Set<LiteralTree> ignoredLoopConditions;

    public void startOfExecution(Scope functionScope) {
        this.ignoredLoopConditions = new HashSet<LiteralTree>();
        Tree tree = functionScope.tree();
        new LoopsVisitor().scanTree(tree);
    }

    public void checkConditions(Map<Tree, Collection<Constraint>> conditions) {
        for (Map.Entry<Tree, Collection<Constraint>> entry : conditions.entrySet()) {
            Collection<Constraint> results;
            Tree conditionTree = entry.getKey();
            if (this.ignoredLoopConditions.contains(conditionTree) || (results = entry.getValue()).size() != 1) continue;
            Constraint constraint = results.iterator().next();
            boolean isTruthy = Constraint.TRUTHY.equals((Object)constraint);
            Set<Tree> neverExecutedCode = AbstractAlwaysTrueOrFalseConditionCheck.getNeverExecutedCode(conditionTree, isTruthy);
            if (neverExecutedCode.isEmpty()) {
                this.redundantCondition(conditionTree, isTruthy);
                continue;
            }
            this.conditionWithDeadCode(conditionTree, isTruthy, neverExecutedCode);
        }
    }

    private static Set<Tree> getNeverExecutedCode(Tree condition, boolean isTruthy) {
        HashSet<Tree> neverExecutedCode = new HashSet<Tree>();
        Tree biggestTreeWithSameTruthiness = AbstractAlwaysTrueOrFalseConditionCheck.biggestTreeWithSameTruthiness(condition, isTruthy, neverExecutedCode);
        Tree parent = CheckUtils.parentIgnoreParentheses(biggestTreeWithSameTruthiness);
        if (parent.is(new Kinds[]{Tree.Kind.IF_STATEMENT})) {
            IfStatementTree ifStatementTree = (IfStatementTree)parent;
            if (isTruthy) {
                if (ifStatementTree.elseClause() != null) {
                    neverExecutedCode.add((Tree)ifStatementTree.elseClause());
                }
            } else {
                neverExecutedCode.add((Tree)ifStatementTree.statement());
            }
        } else if (parent.is(new Kinds[]{KindSet.LOOP_KINDS}) && !isTruthy) {
            neverExecutedCode.add((Tree)((IterationStatementTree)parent).statement());
        } else if (parent.is(new Kinds[]{Tree.Kind.CONDITIONAL_EXPRESSION})) {
            ConditionalExpressionTree conditionalExpressionTree = (ConditionalExpressionTree)parent;
            neverExecutedCode.add((Tree)(isTruthy ? conditionalExpressionTree.falseExpression() : conditionalExpressionTree.trueExpression()));
        }
        return neverExecutedCode;
    }

    private static Tree biggestTreeWithSameTruthiness(Tree condition, boolean isTruthy, Set<Tree> neverExecutedCode) {
        Tree parent = CheckUtils.parentIgnoreParentheses(condition);
        if (parent.is(new Kinds[]{Tree.Kind.CONDITIONAL_OR}) && isTruthy || parent.is(new Kinds[]{Tree.Kind.CONDITIONAL_AND}) && !isTruthy) {
            BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)parent;
            if (binaryExpressionTree.leftOperand().equals(condition)) {
                neverExecutedCode.add((Tree)binaryExpressionTree.rightOperand());
            }
            return AbstractAlwaysTrueOrFalseConditionCheck.biggestTreeWithSameTruthiness(parent, isTruthy, neverExecutedCode);
        }
        return condition;
    }

    protected void conditionWithDeadCode(Tree condition, boolean isTruthy, Set<Tree> deadCode) {
    }

    protected void redundantCondition(Tree condition, boolean isTruthy) {
    }

    private class LoopsVisitor
    extends SubscriptionVisitor {
        private LoopsVisitor() {
        }

        public Set<Tree.Kind> nodesToVisit() {
            return ImmutableSet.of((Object)Tree.Kind.FOR_STATEMENT, (Object)Tree.Kind.WHILE_STATEMENT, (Object)Tree.Kind.DO_WHILE_STATEMENT);
        }

        public void visitNode(Tree tree) {
            ExpressionTree condition = ((ConditionalTree)tree).condition();
            if (condition != null && condition.is(new Kinds[]{Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.NUMERIC_LITERAL})) {
                AbstractAlwaysTrueOrFalseConditionCheck.this.ignoredLoopConditions.add((LiteralTree)condition);
            }
        }
    }
}

