/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IterationStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="CurlyBraces")
public class AlwaysUseCurlyBracesCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Add curly braces around the nested statement(s) in this \"%s\" block.";

    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.builder().add((Object)Tree.Kind.IF_STATEMENT).add((Object)Tree.Kind.ELSE_CLAUSE).addAll((Iterable)KindSet.LOOP_KINDS.getSubKinds()).build();
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.ELSE_CLAUSE})) {
            this.visitElseClause(tree);
        } else if (tree.is(new Kinds[]{Tree.Kind.IF_STATEMENT})) {
            this.checkAreCurlyBracesUsed(((IfStatementTree)tree).statement(), tree);
        } else {
            this.checkAreCurlyBracesUsed(((IterationStatementTree)tree).statement(), tree);
        }
    }

    private void visitElseClause(Tree tree) {
        if (!((ElseClauseTree)tree).statement().is(new Kinds[]{Tree.Kind.IF_STATEMENT})) {
            this.checkAreCurlyBracesUsed(((ElseClauseTree)tree).statement(), tree);
        }
    }

    private void checkAreCurlyBracesUsed(StatementTree statement, Tree tree) {
        if (!statement.is(new Kinds[]{Tree.Kind.BLOCK})) {
            SyntaxToken firstToken = tree.firstToken();
            this.addIssue((Tree)firstToken, String.format(MESSAGE, firstToken.text()));
        }
    }
}

