/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="ArrayAndObjectConstructors")
public class ArrayConstructorsCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Use a literal instead of the Array constructor.";

    public void visitNewExpression(NewExpressionTree tree) {
        String constructorName;
        ExpressionTree expression = tree.expression();
        if (expression.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE}) && "Array".equals(constructorName = ((IdentifierTree)expression).name())) {
            this.addIssue((Tree)tree, MESSAGE);
        }
        super.visitNewExpression(tree);
    }
}

