/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.ConditionalTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="BitwiseOperators")
public class BitwiseOperatorsCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Review this use of bitwise \"%s\" operator; conditional \"%<s%<s\" might have been intended.";
    private SyntaxToken lonelyBitwiseAndOr = null;
    private boolean fileContainsBitwiseOperations = false;

    public void visitFile(Tree scriptTree) {
        this.lonelyBitwiseAndOr = null;
        this.fileContainsBitwiseOperations = false;
    }

    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.builder().add((Object)Tree.Kind.BITWISE_AND).add((Object)Tree.Kind.BITWISE_OR).add((Object)Tree.Kind.BITWISE_XOR).add((Object)Tree.Kind.BITWISE_COMPLEMENT).add((Object)Tree.Kind.LEFT_SHIFT).add((Object)Tree.Kind.RIGHT_SHIFT).add((Object)Tree.Kind.UNSIGNED_RIGHT_SHIFT).add((Object)Tree.Kind.AND_ASSIGNMENT).add((Object)Tree.Kind.OR_ASSIGNMENT).add((Object)Tree.Kind.XOR_ASSIGNMENT).add((Object)Tree.Kind.LEFT_SHIFT_ASSIGNMENT).add((Object)Tree.Kind.RIGHT_SHIFT_ASSIGNMENT).add((Object)Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT).build();
    }

    public void visitNode(Tree tree) {
        if (this.lonelyBitwiseAndOr == null && tree.is(new Kinds[]{Tree.Kind.BITWISE_AND, Tree.Kind.BITWISE_OR}) && !((BinaryExpressionTree)tree).rightOperand().is(new Kinds[]{Tree.Kind.NUMERIC_LITERAL})) {
            this.lonelyBitwiseAndOr = ((BinaryExpressionTree)tree).operatorToken();
        } else {
            this.fileContainsBitwiseOperations = true;
        }
    }

    public void leaveFile(Tree scriptTree) {
        if (!this.fileContainsBitwiseOperations && this.lonelyBitwiseAndOr != null && BitwiseOperatorsCheck.insideCondition(this.lonelyBitwiseAndOr)) {
            String message = String.format(MESSAGE, this.lonelyBitwiseAndOr.text());
            this.addIssue((Tree)this.lonelyBitwiseAndOr, message);
        }
    }

    private static boolean insideCondition(SyntaxToken token) {
        Tree treeWithCondition = CheckUtils.getFirstAncestor((Tree)token, new Kinds[]{Tree.Kind.IF_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.DO_WHILE_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.CONDITIONAL_EXPRESSION});
        if (treeWithCondition == null) {
            return false;
        }
        ExpressionTree condition = ((ConditionalTree)treeWithCondition).condition();
        return condition != null && condition.isAncestorOf((Tree)token);
    }
}

