/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.metrics.CognitiveComplexity;
import org.sonar.javascript.metrics.FunctionDefiningModuleVisitor;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S3776")
public class CognitiveComplexityFunctionCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Refactor this function to reduce its Cognitive Complexity from %s to the %s allowed.";
    private static final int DEFAULT_THRESHOLD = 15;
    @RuleProperty(key="threshold", description="The maximum authorized complexity.", defaultValue="15")
    private int threshold = 15;
    private Set<Tree> ignoredNestedFunctions = new HashSet<Tree>();
    private Set<FunctionTree> functionsDefiningModule = new HashSet<FunctionTree>();

    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.builder().addAll((Iterable)KindSet.FUNCTION_KINDS.getSubKinds()).add((Object)Tree.Kind.SCRIPT).build();
    }

    public void visitFile(Tree scriptTree) {
        this.ignoredNestedFunctions.clear();
        super.visitFile(scriptTree);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.SCRIPT})) {
            this.functionsDefiningModule = FunctionDefiningModuleVisitor.getFunctionsDefiningModule((ScriptTree)((ScriptTree)tree));
            return;
        }
        if (!this.ignoredNestedFunctions.contains(tree)) {
            CognitiveComplexity.ComplexityData complexityData = new CognitiveComplexity().calculateFunctionComplexity((FunctionTree)tree, this.functionsDefiningModule.contains(tree));
            this.ignoredNestedFunctions.addAll(complexityData.aggregatedNestedFunctions());
            if (complexityData.complexity() > this.threshold) {
                this.raiseIssue(complexityData, tree);
            }
        }
    }

    private void raiseIssue(CognitiveComplexity.ComplexityData complexityData, Tree function) {
        String message = String.format(MESSAGE, complexityData.complexity(), this.threshold);
        SyntaxToken primaryLocation = function.firstToken();
        if (function.is(new Kinds[]{Tree.Kind.ARROW_FUNCTION})) {
            primaryLocation = ((ArrowFunctionTree)function).doubleArrowToken();
        }
        PreciseIssue issue = this.addIssue((Tree)primaryLocation, message).cost((double)complexityData.complexity() - (double)this.threshold);
        complexityData.secondaryLocations().forEach(arg_0 -> ((PreciseIssue)issue).secondary(arg_0));
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

