/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.CaseClauseTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S3616")
public class CommaOperatorInSwitchCaseCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Explicitly specify %d separate cases that fall through; currently this case clause only works for \"%s\".";

    public void visitCaseClause(CaseClauseTree tree) {
        List<ExpressionTree> expressionTrees;
        ExpressionTree expression = tree.expression();
        if (expression.is(new Kinds[]{Tree.Kind.COMMA_OPERATOR})) {
            int nbCommas = CommaOperatorInSwitchCaseCheck.getNumberOfCommas(expression);
            this.raiseIssue(expression, nbCommas + 1, ((BinaryExpressionTree)expression).rightOperand());
        }
        if (expression.is(new Kinds[]{Tree.Kind.CONDITIONAL_OR}) && !(expressionTrees = CommaOperatorInSwitchCaseCheck.orExpressionOperands(expression)).isEmpty()) {
            this.raiseIssue(expression, expressionTrees.size(), expressionTrees.get(0));
        }
        super.visitCaseClause(tree);
    }

    private void raiseIssue(ExpressionTree expression, int operandsNumber, ExpressionTree expressionResult) {
        String lastCase = CheckUtils.asString((Tree)expressionResult);
        String msg = String.format(MESSAGE, operandsNumber, lastCase);
        this.addIssue((Tree)expression, msg);
    }

    private static int getNumberOfCommas(ExpressionTree expression) {
        int nbCommas = 0;
        if (expression.is(new Kinds[]{Tree.Kind.COMMA_OPERATOR})) {
            BinaryExpressionTree binaryExpression = (BinaryExpressionTree)expression;
            nbCommas = CommaOperatorInSwitchCaseCheck.getNumberOfCommas(binaryExpression.leftOperand()) + 1;
        }
        return nbCommas;
    }

    private static List<ExpressionTree> orExpressionOperands(ExpressionTree expression) {
        if (expression.is(new Kinds[]{Tree.Kind.CONDITIONAL_OR})) {
            List<ExpressionTree> expressionTrees;
            BinaryExpressionTree binaryExpression = (BinaryExpressionTree)expression;
            if (binaryExpression.rightOperand().is(new Kinds[]{KindSet.LITERAL_KINDS}) && !(expressionTrees = CommaOperatorInSwitchCaseCheck.orExpressionOperands(binaryExpression.leftOperand())).isEmpty()) {
                expressionTrees.add(binaryExpression.rightOperand());
                return expressionTrees;
            }
        } else if (expression.is(new Kinds[]{KindSet.LITERAL_KINDS})) {
            return Lists.newArrayList((Object[])new ExpressionTree[]{expression});
        }
        return ImmutableList.of();
    }
}

