/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.LineIssue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;
import org.sonar.squidbridge.annotations.RuleTemplate;

@Rule(key="CommentRegularExpression")
@RuleTemplate
public class CommentRegularExpressionCheck
extends SubscriptionVisitorCheck {
    private static final String DEFAULT_MESSAGE = "The regular expression matches this comment.";
    private static final String DEFAULT_REGULAR_EXPRESSION = "";
    @RuleProperty(key="regularExpression", description="The regular expression", defaultValue="")
    private String regularExpression = "";
    @RuleProperty(key="message", description="The issue message", defaultValue="The regular expression matches this comment.")
    private String message = "The regular expression matches this comment.";
    private Pattern pattern = null;

    public void setMessage(String message) {
        this.message = message;
    }

    public void setRegularExpression(String regularExpression) {
        this.regularExpression = regularExpression;
    }

    public void visitNode(Tree tree) {
        if (this.pattern == null && !Strings.isNullOrEmpty((String)this.regularExpression)) {
            try {
                this.pattern = Pattern.compile(this.regularExpression, 32);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Unable to compile regular expression: " + this.regularExpression, e);
            }
        }
        if (this.pattern != null) {
            SyntaxToken token = (SyntaxToken)tree;
            for (SyntaxTrivia trivia : token.trivias()) {
                if (!this.pattern.matcher(trivia.text()).matches()) continue;
                this.addIssue((Issue)new LineIssue((JavaScriptCheck)this, trivia.line(), this.message));
            }
        }
    }

    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.of((Object)Tree.Kind.TOKEN);
    }
}

