/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S2688")
public class ComparisonWithNaNCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Use a test of the format \"a %s a\" instead.";
    private static final String NAN = "NaN";

    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.copyOf((Collection)KindSet.EQUALITY_KINDS.getSubKinds());
    }

    public void visitNode(Tree tree) {
        BinaryExpressionTree expression = (BinaryExpressionTree)tree;
        ExpressionTree nan = ComparisonWithNaNCheck.getNaN(expression);
        if (nan != null) {
            this.addIssue((Tree)nan, String.format(MESSAGE, expression.operatorToken().text())).secondary((Tree)expression.operatorToken());
        }
    }

    private static boolean isNaN(ExpressionTree expression) {
        if (expression.is(new Kinds[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            DotMemberExpressionTree memberExpression = (DotMemberExpressionTree)expression;
            return ComparisonWithNaNCheck.isIdentifier((Tree)memberExpression.object(), "Number") && ComparisonWithNaNCheck.isIdentifier((Tree)memberExpression.property(), NAN);
        }
        return ComparisonWithNaNCheck.isIdentifier((Tree)expression, NAN);
    }

    private static boolean isIdentifier(Tree tree, String value) {
        return tree instanceof IdentifierTree && value.equals(((IdentifierTree)tree).name());
    }

    @CheckForNull
    private static ExpressionTree getNaN(BinaryExpressionTree expression) {
        if (ComparisonWithNaNCheck.isNaN(expression.leftOperand())) {
            return expression.leftOperand();
        }
        if (ComparisonWithNaNCheck.isNaN(expression.rightOperand())) {
            return expression.rightOperand();
        }
        return null;
    }
}

