/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractDuplicateBranchImplementationCheck;
import org.sonar.javascript.tree.SyntacticEquivalence;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ConditionalExpressionTree;

@Rule(key="S3923")
public class DuplicateAllBranchImplementationCheck
extends AbstractDuplicateBranchImplementationCheck {
    private static final String MESSAGE = "Remove this conditional structure or edit its code blocks so that they're not all the same.";
    private static final String MESSAGE_CONDITIONAL_EXPRESSION = "This conditional operation returns the same value whether the condition is \"true\" or \"false\".";

    @Override
    protected void checkDuplicatedBranches(List<Tree> branches) {
    }

    @Override
    protected void allBranchesDuplicated(Tree tree) {
        this.addIssue(tree, MESSAGE);
    }

    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        if (SyntacticEquivalence.areEquivalent((Tree)tree.trueExpression(), (Tree)tree.falseExpression())) {
            this.addIssue((Tree)tree, MESSAGE_CONDITIONAL_EXPRESSION);
        }
        super.visitConditionalExpression(tree);
    }
}

