/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="EmptyBlock")
public class EmptyBlockCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Either remove or fill this block of code.";

    public void visitBlock(BlockTree tree) {
        Tree parent = tree.parent();
        if (!parent.is(new Kinds[]{KindSet.FUNCTION_KINDS, Tree.Kind.CATCH_BLOCK}) && tree.statements().isEmpty() && !EmptyBlockCheck.hasComment(tree.closeCurlyBraceToken())) {
            this.addIssue((Tree)tree, MESSAGE);
        }
        super.visitBlock(tree);
    }

    private static boolean hasComment(SyntaxToken closingBrace) {
        return !closingBrace.trivias().isEmpty();
    }
}

