/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.AccessorMethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S1186")
public class EmptyFunctionCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Add a nested comment explaining why this function is empty or complete the implementation.";

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.checkFunction((FunctionTree)tree, (Tree)tree.name());
        super.visitFunctionDeclaration(tree);
    }

    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.checkFunction((FunctionTree)tree, (Tree)tree.functionKeyword());
        super.visitFunctionExpression(tree);
    }

    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.checkFunction((FunctionTree)tree, tree.name());
        super.visitMethodDeclaration(tree);
    }

    public void visitAccessorMethodDeclaration(AccessorMethodDeclarationTree tree) {
        this.checkFunction((FunctionTree)tree, tree.name());
        super.visitAccessorMethodDeclaration(tree);
    }

    public void visitArrowFunction(ArrowFunctionTree tree) {
        this.checkFunction((FunctionTree)tree, tree.body());
        super.visitArrowFunction(tree);
    }

    private void checkFunction(FunctionTree tree, Tree issueLocationTree) {
        BlockTree body;
        if (tree.body() instanceof BlockTree && (body = (BlockTree)tree.body()).statements().isEmpty() && body.closeCurlyBraceToken().trivias().isEmpty()) {
            this.addIssue(issueLocationTree, MESSAGE);
        }
    }
}

