/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.ModuleTree;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.EmptyStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S1116")
public class EmptyStatementCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove this empty statement.";
    private Set<EmptyStatementTree> exceptedStatements;

    public void visitScript(ScriptTree tree) {
        this.exceptedStatements = new HashSet<EmptyStatementTree>();
        ModuleTree module = tree.items();
        if (module != null && !module.items().isEmpty()) {
            this.except((Tree)module.items().get(0));
        }
        super.visitScript(tree);
    }

    public void visitIfStatement(IfStatementTree tree) {
        this.except((Tree)tree.statement());
        super.visitIfStatement(tree);
    }

    public void visitElseClause(ElseClauseTree tree) {
        this.except((Tree)tree.statement());
        super.visitElseClause(tree);
    }

    public void visitForStatement(ForStatementTree tree) {
        this.except((Tree)tree.statement());
        super.visitForStatement(tree);
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        this.except((Tree)tree.statement());
        super.visitWhileStatement(tree);
    }

    public void visitEmptyStatement(EmptyStatementTree tree) {
        if (!this.exceptedStatements.contains(tree)) {
            this.addIssue((Tree)tree, MESSAGE);
        }
    }

    private void except(Tree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.EMPTY_STATEMENT})) {
            this.exceptedStatements.add((EmptyStatementTree)tree);
        }
    }
}

