/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ArgumentListTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="Eval")
public class EvalCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Review the arguments of this \"eval\" call to make sure they are validated.";

    public void visitCallExpression(CallExpressionTree tree) {
        ExpressionTree callee = tree.callee();
        if (callee.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE}) && "eval".equals(((IdentifierTree)callee).name()) && EvalCheck.atLeastOneArgumentNotLiteral(tree.argumentClause())) {
            this.addIssue((Tree)callee, MESSAGE);
        }
        super.visitCallExpression(tree);
    }

    private static boolean atLeastOneArgumentNotLiteral(ArgumentListTree arguments) {
        for (ExpressionTree expressionTree : arguments.arguments()) {
            if (expressionTree.is(new Kinds[]{Tree.Kind.STRING_LITERAL})) continue;
            return true;
        }
        return false;
    }
}

