/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ArgumentListTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S1472")
public class FunctionCallArgumentsOnNewLineCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Make those call arguments start on line %s";

    public void visitCallExpression(CallExpressionTree tree) {
        int argumentsFirstLine;
        int calleeLastLine;
        if (!this.isChainedCall(tree) && this.callExpressionWasLikelyIntended(tree.argumentClause()) && (calleeLastLine = tree.callee().lastToken().endLine()) != (argumentsFirstLine = tree.argumentClause().firstToken().line())) {
            this.addIssue((Tree)tree.argumentClause(), String.format(MESSAGE, calleeLastLine));
        }
        super.visitCallExpression(tree);
    }

    public boolean isChainedCall(CallExpressionTree tree) {
        return tree.callee().is(new Kinds[]{Tree.Kind.CALL_EXPRESSION});
    }

    public boolean callExpressionWasLikelyIntended(ArgumentListTree argumentListTree) {
        return argumentListTree.arguments().size() == 1;
    }
}

