/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.PairPropertyTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableDeclarationTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S100")
public class FunctionNameCheck
extends DoubleDispatchVisitorCheck {
    public static final String DEFAULT = "^[_a-z][a-zA-Z0-9]*$";
    private static final String MESSAGE = "Rename this '%s' function to match the regular expression %s";
    private Pattern pattern = null;
    @RuleProperty(key="format", description="Regular expression used to check the function names against.", defaultValue="^[_a-z][a-zA-Z0-9]*$")
    public String format = "^[_a-z][a-zA-Z0-9]*$";

    public void visitScript(ScriptTree tree) {
        this.pattern = Pattern.compile(this.format);
        super.visitScript(tree);
    }

    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.checkName(tree.name());
        super.visitMethodDeclaration(tree);
    }

    public void visitPairProperty(PairPropertyTree tree) {
        if (FunctionNameCheck.isFunctionExpression((Tree)tree.value())) {
            this.checkName(tree.key());
        }
        super.visitPairProperty(tree);
    }

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.checkName((Tree)tree.name());
        super.visitFunctionDeclaration(tree);
    }

    public void visitVariableDeclaration(VariableDeclarationTree tree) {
        for (BindingElementTree bindingElement : tree.variables()) {
            InitializedBindingElementTree initializedBindingElement;
            if (!bindingElement.is(new Kinds[]{Tree.Kind.INITIALIZED_BINDING_ELEMENT}) || !FunctionNameCheck.isFunctionExpression((Tree)(initializedBindingElement = (InitializedBindingElementTree)bindingElement).right())) continue;
            this.checkName((Tree)initializedBindingElement.left());
        }
        super.visitVariableDeclaration(tree);
    }

    private static boolean isFunctionExpression(Tree tree) {
        return tree.is(new Kinds[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, Tree.Kind.ARROW_FUNCTION});
    }

    private void checkName(Tree tree) {
        String name;
        if (tree instanceof IdentifierTree && !this.pattern.matcher(name = ((IdentifierTree)tree).name()).matches()) {
            this.addIssue(tree, String.format(MESSAGE, name, this.format));
        }
    }
}

