/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractAlwaysTrueOrFalseConditionCheck;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;

@Rule(key="S2589")
public class GratuitousConditionCheck
extends AbstractAlwaysTrueOrFalseConditionCheck {
    private static final String MESSAGE = "Refactor this code so that this expression does not always evaluate to %s.";

    @Override
    protected void redundantCondition(Tree condition, boolean isTruthy) {
        if (!GratuitousConditionCheck.isTruthyLiteral(condition, isTruthy) && !condition.is(new Kinds[]{Tree.Kind.ASSIGNMENT})) {
            String result = isTruthy ? "true" : "false";
            this.addIssue(condition, String.format(MESSAGE, result));
        }
    }

    private static boolean isTruthyLiteral(Tree tree, boolean isTruthy) {
        ExpressionTree conditionWithoutParentheses = CheckUtils.removeParenthesis((ExpressionTree)tree);
        return isTruthy && conditionWithoutParentheses.is(new Kinds[]{Tree.Kind.ARRAY_LITERAL, Tree.Kind.OBJECT_LITERAL, Tree.Kind.NEW_EXPRESSION, Tree.Kind.NUMERIC_LITERAL, Tree.Kind.STRING_LITERAL});
    }
}

