/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;

@Rule(key="S3686")
public class InconsistentFunctionCallCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Correct the use of this function; on line %s it was called with%s \"new\".";
    private static final String SECONDARY_MESSAGE = "Called with%s \"new\"";
    private Set<Symbol> hasIssue = new HashSet<Symbol>();
    private Map<Symbol, CallExpressionTree> usedInCallExpression = new HashMap<Symbol, CallExpressionTree>();
    private Map<Symbol, NewExpressionTree> usedInNewExpression = new HashMap<Symbol, NewExpressionTree>();

    public void visitScript(ScriptTree tree) {
        super.visitScript(tree);
        this.usedInCallExpression.clear();
        this.usedInNewExpression.clear();
    }

    public void visitCallExpression(CallExpressionTree tree) {
        this.checkExpression(tree, tree.callee(), this.usedInNewExpression, this.usedInCallExpression, "");
        super.visitCallExpression(tree);
    }

    public void visitNewExpression(NewExpressionTree tree) {
        this.checkExpression(tree, tree.expression(), this.usedInCallExpression, this.usedInNewExpression, "out");
        super.visitNewExpression(tree);
    }

    private <T1 extends Tree, T2 extends Tree> void checkExpression(T1 tree, ExpressionTree symbolTree, Map<Symbol, T2> otherTypeUsageMap, Map<Symbol, T1> thisTypeUsageMap, String tail) {
        Symbol symbol = InconsistentFunctionCallCheck.getSymbol(symbolTree);
        if (symbol == null || symbol.external()) {
            return;
        }
        Tree otherTypeUsage = (Tree)otherTypeUsageMap.get(symbol);
        if (otherTypeUsage != null && !this.hasIssue.contains(symbol)) {
            String message = String.format(MESSAGE, otherTypeUsage.firstToken().line(), tail);
            String secondaryMessage = String.format(SECONDARY_MESSAGE, tail);
            ((PreciseIssue)this.addIssue((Issue)new PreciseIssue((JavaScriptCheck)this, InconsistentFunctionCallCheck.issueLocation(tree, message)))).secondary(InconsistentFunctionCallCheck.issueLocation(otherTypeUsage, secondaryMessage));
            this.hasIssue.add(symbol);
        } else {
            thisTypeUsageMap.put(symbol, tree);
        }
    }

    private static <T extends Tree> IssueLocation issueLocation(T tree, String message) {
        if (tree.is(new Kinds[]{Tree.Kind.NEW_EXPRESSION})) {
            NewExpressionTree newExpressionTree = (NewExpressionTree)tree;
            return new IssueLocation((Tree)newExpressionTree.newKeyword(), (Tree)newExpressionTree.expression(), message);
        }
        CallExpressionTree callExpressionTree = (CallExpressionTree)tree;
        return new IssueLocation((Tree)callExpressionTree.callee(), message);
    }

    @CheckForNull
    private static Symbol getSymbol(ExpressionTree expression) {
        if (expression.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
            return ((IdentifierTree)expression).symbol().orElse(null);
        }
        return null;
    }
}

