/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.JavaScriptFile;
import org.sonar.plugins.javascript.api.visitors.LineIssue;

@Rule(key="LineLength")
public class LineLengthCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Split this %s characters long line (which is greater than %s authorized).";
    private static final int DEFAULT_MAXIMUM_LINE_LENGTH = 180;
    @RuleProperty(key="maximumLineLength", description="The maximum authorized line length.", defaultValue="180")
    public int maximumLineLength = 180;

    public void visitScript(ScriptTree tree) {
        JavaScriptFile file = this.getContext().getJavaScriptFile();
        List<String> lines = CheckUtils.readLines(file);
        for (int i = 0; i < lines.size(); ++i) {
            int length = lines.get(i).length();
            if (length <= this.maximumLineLength) continue;
            this.addIssue((Issue)new LineIssue((JavaScriptCheck)this, i + 1, String.format(MESSAGE, length, this.maximumLineLength)));
        }
    }
}

