/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.symbols.type.FunctionType;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S2234")
public class MisorderedParameterListCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE_FORMAT = "Arguments to %s have the same names but not the same order as the function parameters.";

    public void visitCallExpression(CallExpressionTree callExpression) {
        List<String> parameterNames;
        FunctionTree functionDeclaration;
        List<String> argumentNames = MisorderedParameterListCheck.names(callExpression.argumentClause().arguments());
        if (argumentNames != null && (functionDeclaration = MisorderedParameterListCheck.functionDeclaration(callExpression)) != null && (parameterNames = MisorderedParameterListCheck.names(MisorderedParameterListCheck.parameters(functionDeclaration))) != null && MisorderedParameterListCheck.haveSameNamesAndDifferentOrders(argumentNames, parameterNames)) {
            this.addIssue((Tree)callExpression.argumentClause(), MisorderedParameterListCheck.message(functionDeclaration)).secondary(functionDeclaration.parameterClause());
        }
        super.visitCallExpression(callExpression);
    }

    private static List<BindingElementTree> parameters(FunctionTree functionTree) {
        if (functionTree.parameterClause().is(new Kinds[]{Tree.Kind.PARAMETER_LIST})) {
            return ((ParameterListTree)functionTree.parameterClause()).parameters();
        }
        return ImmutableList.of((Object)((IdentifierTree)functionTree.parameterClause()));
    }

    @CheckForNull
    private static FunctionTree functionDeclaration(CallExpressionTree tree) {
        TypeSet types = tree.callee().types();
        FunctionType functionType = (FunctionType)types.getUniqueType(Type.Kind.FUNCTION);
        return functionType == null ? null : functionType.functionTree();
    }

    private static boolean haveSameNamesAndDifferentOrders(List<String> argumentNames, List<String> parameterNames) {
        return new HashSet<String>(argumentNames).equals(new HashSet<String>(parameterNames)) && !argumentNames.equals(parameterNames);
    }

    @CheckForNull
    private static <T extends Tree> List<String> names(List<T> list) {
        ArrayList<String> names = new ArrayList<String>();
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            Tree param;
            Tree paramId = param = (Tree)iterator.next();
            if (param.is(new Kinds[]{Tree.Kind.INITIALIZED_BINDING_ELEMENT})) {
                InitializedBindingElementTree initialized = (InitializedBindingElementTree)param;
                paramId = initialized.left();
            }
            if (!paramId.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE, Tree.Kind.BINDING_IDENTIFIER})) {
                return null;
            }
            names.add(((IdentifierTree)paramId).name().toLowerCase(Locale.ENGLISH));
        }
        return names;
    }

    private static String message(FunctionTree functionDeclaration) {
        String parameter = "this call";
        if (functionDeclaration.is(new Kinds[]{Tree.Kind.FUNCTION_DECLARATION})) {
            parameter = "\"" + ((FunctionDeclarationTree)functionDeclaration).name().name() + "\"";
        }
        return String.format(MESSAGE_FORMAT, parameter);
    }
}

