/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.ClassTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.javascript.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.FinallyBlockTree;
import org.sonar.plugins.javascript.api.tree.statement.ForObjectStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.TryStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WithStatementTree;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S1105")
public class OpenCurlyBracesAtEOLCheck
extends SubscriptionVisitorCheck {
    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.of((Object)Tree.Kind.BLOCK, (Object)Tree.Kind.OBJECT_LITERAL, (Object)Tree.Kind.SWITCH_STATEMENT, (Object)Tree.Kind.CLASS_DECLARATION, (Object)Tree.Kind.CLASS_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.BLOCK})) {
            BlockTree body = (BlockTree)tree;
            Tree parent = body.parent();
            SyntaxToken openCurly = body.openCurlyBraceToken();
            openCurly.column();
            this.checkFunction(parent, openCurly);
            this.checkConditional(parent, openCurly);
            this.checkLoop(parent, openCurly);
            this.checkTryCatchFinally(body, parent, openCurly);
            this.checkWith(parent, openCurly);
        }
        if (tree.is(new Kinds[]{Tree.Kind.OBJECT_LITERAL})) {
            ObjectLiteralTree objectLiteral = (ObjectLiteralTree)tree;
            SyntaxToken openCurly = objectLiteral.openCurlyBraceToken();
            Tree parent = objectLiteral.parent();
            this.checkAssignment(openCurly, parent);
        }
        if (tree.is(new Kinds[]{Tree.Kind.SWITCH_STATEMENT})) {
            this.checkSwitch((SwitchStatementTree)tree);
        }
        if (tree.is(new Kinds[]{Tree.Kind.CLASS_DECLARATION, Tree.Kind.CLASS_EXPRESSION})) {
            this.checkClass((ClassTree)tree);
        }
    }

    private void checkAssignment(SyntaxToken openCurly, Tree parent) {
        if (parent.is(new Kinds[]{Tree.Kind.INITIALIZED_BINDING_ELEMENT})) {
            this.issueIfLineMismatch(openCurly, ((InitializedBindingElementTree)parent).equalToken());
        }
    }

    private void checkClass(ClassTree classTree) {
        if (classTree.extendsClause() != null) {
            this.issueIfLineMismatch(classTree.openCurlyBraceToken(), classTree.extendsClause().extendsToken());
        } else {
            this.issueIfLineMismatch(classTree.openCurlyBraceToken(), classTree.classToken());
        }
    }

    private void checkSwitch(SwitchStatementTree switchStatement) {
        this.issueIfLineMismatch(switchStatement.openCurlyBraceToken(), switchStatement.closeParenthesisToken());
    }

    private void checkWith(Tree parent, SyntaxToken openCurly) {
        if (parent.is(new Kinds[]{Tree.Kind.WITH_STATEMENT})) {
            this.issueIfLineMismatch(openCurly, ((WithStatementTree)parent).closingParenthesisToken());
        }
    }

    private void checkTryCatchFinally(BlockTree body, Tree parent, SyntaxToken openCurly) {
        TryStatementTree tryStatementTree;
        if (parent.is(new Kinds[]{Tree.Kind.TRY_STATEMENT}) && (tryStatementTree = (TryStatementTree)parent).block().equals(body)) {
            this.issueIfLineMismatch(openCurly, tryStatementTree.tryKeyword());
        }
        if (parent.is(new Kinds[]{Tree.Kind.CATCH_BLOCK})) {
            this.issueIfLineMismatch(openCurly, ((CatchBlockTree)parent).catchKeyword());
        }
        if (parent.is(new Kinds[]{Tree.Kind.FINALLY_BLOCK})) {
            this.issueIfLineMismatch(openCurly, ((FinallyBlockTree)parent).finallyKeyword());
        }
    }

    private void checkLoop(Tree parent, SyntaxToken openCurly) {
        if (parent.is(new Kinds[]{Tree.Kind.DO_WHILE_STATEMENT})) {
            this.issueIfLineMismatch(openCurly, ((DoWhileStatementTree)parent).doKeyword());
        }
        if (parent.is(new Kinds[]{Tree.Kind.WHILE_STATEMENT})) {
            this.issueIfLineMismatch(openCurly, ((WhileStatementTree)parent).closeParenthesisToken());
        }
        if (parent.is(new Kinds[]{Tree.Kind.FOR_STATEMENT})) {
            this.issueIfLineMismatch(openCurly, ((ForStatementTree)parent).closeParenthesisToken());
        }
        if (parent.is(new Kinds[]{Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_OF_STATEMENT})) {
            this.issueIfLineMismatch(openCurly, ((ForObjectStatementTree)parent).closeParenthesisToken());
        }
    }

    private void checkConditional(Tree parent, SyntaxToken openCurly) {
        if (parent.is(new Kinds[]{Tree.Kind.IF_STATEMENT})) {
            this.issueIfLineMismatch(openCurly, ((IfStatementTree)parent).closeParenthesisToken());
        }
        if (parent.is(new Kinds[]{Tree.Kind.ELSE_CLAUSE})) {
            this.issueIfLineMismatch(openCurly, ((ElseClauseTree)parent).elseKeyword());
        }
    }

    private void checkFunction(Tree parent, SyntaxToken openCurly) {
        if (parent.is(new Kinds[]{Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.METHOD, Tree.Kind.GENERATOR_DECLARATION, Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION})) {
            this.issueIfLineMismatch(openCurly, OpenCurlyBracesAtEOLCheck.getParameterList((FunctionTree)parent).closeParenthesisToken());
        }
        if (parent.is(new Kinds[]{Tree.Kind.ARROW_FUNCTION})) {
            this.issueIfLineMismatch(openCurly, ((ArrowFunctionTree)parent).doubleArrowToken());
        }
    }

    private static ParameterListTree getParameterList(FunctionTree parent) {
        return (ParameterListTree)parent.parameterClause();
    }

    private void issueIfLineMismatch(SyntaxToken curlyBrace, SyntaxToken target) {
        CodeLine curlyBraceLine = new CodeLine(curlyBrace.line());
        if (curlyBraceLine.isJustBelow(target.line())) {
            this.addIssue((Issue)new PreciseIssue((JavaScriptCheck)this, new IssueLocation((Tree)curlyBrace, "Move this open curly brace to the end of the previous line.")));
        } else if (curlyBraceLine.isFarBelow(target.line())) {
            this.addIssue((Issue)new PreciseIssue((JavaScriptCheck)this, new IssueLocation((Tree)curlyBrace, "Move this open curly brace to the end of line " + target.line() + ".")));
        }
    }

    private static class CodeLine {
        private final int line;

        CodeLine(int line) {
            this.line = line;
        }

        boolean isJustBelow(int line) {
            return this.line == line + 1;
        }

        boolean isFarBelow(int line) {
            return this.line > line + 1;
        }
    }
}

