/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="Parentheses")
public class ParenthesesCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove those useless parentheses.";

    public void visitParenthesisedExpression(ParenthesisedExpressionTree tree) {
        if (tree.expression().is(new Kinds[]{Tree.Kind.PARENTHESISED_EXPRESSION})) {
            this.addIssue((Tree)tree.openParenthesisToken(), MESSAGE).secondary((Tree)tree.closeParenthesisToken());
        }
        super.visitParenthesisedExpression(tree);
    }
}

