/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.AccessorMethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S2432")
public class ReturnInSetterCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove this return statement.";
    private final DoubleDispatchVisitorCheck forbiddenReturnVisitor = new ForbiddenReturnVisitor();

    public void visitAccessorMethodDeclaration(AccessorMethodDeclarationTree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.SET_METHOD})) {
            tree.body().accept((DoubleDispatchVisitor)this.forbiddenReturnVisitor);
        }
        super.visitAccessorMethodDeclaration(tree);
    }

    private class ForbiddenReturnVisitor
    extends DoubleDispatchVisitorCheck {
        private ForbiddenReturnVisitor() {
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            if (tree.expression() != null) {
                ReturnInSetterCheck check = ReturnInSetterCheck.this;
                check.addIssue((Tree)tree, ReturnInSetterCheck.MESSAGE);
            }
            super.visitReturnStatement(tree);
        }
    }
}

