/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S3834")
public class SymbolUsedAsConstructorCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove this \"new\" operator.";
    private static final String SYMBOL = "Symbol";

    public void visitNewExpression(NewExpressionTree tree) {
        if (this.isSymbol(tree.expression())) {
            this.raiseError(tree);
        }
    }

    private boolean isSymbol(ExpressionTree expression) {
        String name;
        return expression.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE}) && SYMBOL.equals(name = ((IdentifierTree)expression).name()) && !this.isSymbolShadowed((Tree)expression);
    }

    private boolean isSymbolShadowed(Tree tree) {
        Tree scopedTree = CheckUtils.getFirstAncestor(tree, new Kinds[]{KindSet.FUNCTION_KINDS, Tree.Kind.SCRIPT});
        Symbol symbolSymbol = this.getContext().getSymbolModel().getScope(scopedTree).lookupSymbol(SYMBOL);
        return !symbolSymbol.external() || SymbolUsedAsConstructorCheck.hasWriteUsage(symbolSymbol);
    }

    private void raiseError(NewExpressionTree tree) {
        this.addIssue((Tree)tree.newKeyword(), MESSAGE).secondary((Tree)tree.expression());
    }

    private static boolean hasWriteUsage(Symbol symbol) {
        return symbol.usages().stream().anyMatch(usage -> usage.isWrite() || usage.isDeclaration());
    }
}

