/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.FileIssue;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S104")
public class TooManyLinesInFileCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "File \"%s\" has %d lines, which is greater than %d authorized. Split it into smaller files.";
    private static final int DEFAULT = 1000;
    @RuleProperty(key="maximum", description="Maximum authorized lines in a file.", defaultValue="1000")
    public int maximum = 1000;

    public void visitNode(Tree tree) {
        if (!((InternalSyntaxToken)tree).isEOF()) {
            return;
        }
        SyntaxToken token = (SyntaxToken)tree;
        int lines = token.line();
        if (lines > this.maximum) {
            String fileName = this.getContext().getJavaScriptFile().fileName();
            this.addIssue((Issue)new FileIssue((JavaScriptCheck)this, String.format(MESSAGE, fileName, lines, this.maximum)));
        }
    }

    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.of((Object)Tree.Kind.TOKEN);
    }
}

