/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.cfg.CfgBlock;
import org.sonar.javascript.cfg.CfgBranchingBlock;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IterationStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S1751")
public class UnconditionalJumpStatementCheck
extends SubscriptionVisitorCheck {
    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.of((Object)Tree.Kind.BREAK_STATEMENT, (Object)Tree.Kind.CONTINUE_STATEMENT, (Object)Tree.Kind.RETURN_STATEMENT, (Object)Tree.Kind.THROW_STATEMENT);
    }

    public void visitNode(Tree tree) {
        Tree parent = tree.parent();
        while (parent.is(new Kinds[]{Tree.Kind.BLOCK})) {
            parent = parent.parent();
        }
        if (!parent.is(new Kinds[]{KindSet.LOOP_KINDS})) {
            return;
        }
        IterationStatementTree loopTree = (IterationStatementTree)parent;
        if (tree.is(new Kinds[]{Tree.Kind.CONTINUE_STATEMENT}) || !parent.is(new Kinds[]{Tree.Kind.FOR_IN_STATEMENT}) && !UnconditionalJumpStatementCheck.isInfiniteFor(loopTree) && !UnconditionalJumpStatementCheck.canExecuteMoreThanOnce(loopTree)) {
            SyntaxToken keyword = tree.firstToken();
            this.addIssue((Tree)keyword, String.format("Remove this \"%s\" statement or make it conditional", keyword.text()));
        }
    }

    private static boolean isInfiniteFor(IterationStatementTree loopTree) {
        if (loopTree.is(new Kinds[]{Tree.Kind.FOR_STATEMENT})) {
            ForStatementTree forLoop = (ForStatementTree)loopTree;
            return forLoop.update() == null && forLoop.init() == null && forLoop.condition() == null;
        }
        return false;
    }

    private static boolean canExecuteMoreThanOnce(IterationStatementTree loopTree) {
        ControlFlowGraph cfg = CheckUtils.buildControlFlowGraph((Tree)loopTree);
        for (CfgBranchingBlock block : Iterables.filter((Iterable)cfg.blocks(), CfgBranchingBlock.class)) {
            if (!loopTree.equals(block.branchingTree()) || !UnconditionalJumpStatementCheck.hasPredecessorInsideLoopBody(block, loopTree)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasPredecessorInsideLoopBody(CfgBranchingBlock conditionBlock, IterationStatementTree loopTree) {
        for (CfgBlock loopPredecessor : conditionBlock.predecessors()) {
            ForStatementTree forTree;
            List predecessorElements = loopPredecessor.elements();
            Tree predecessorLastElement = (Tree)predecessorElements.get(predecessorElements.size() - 1);
            if (loopTree.is(new Kinds[]{Tree.Kind.FOR_STATEMENT}) && (forTree = (ForStatementTree)loopTree).update() != null && forTree.update().equals(predecessorLastElement)) {
                return !loopPredecessor.predecessors().isEmpty();
            }
            StatementTree loopBody = loopTree.statement();
            if (!CheckUtils.isDescendant(predecessorLastElement, (Tree)loopBody)) continue;
            return true;
        }
        return false;
    }
}

