/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractSymbolNameCheck;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.tree.ScriptTree;

@Rule(key="S2137")
public class UndefinedShadowingCheck
extends AbstractSymbolNameCheck {
    private static final String MESSAGE = "Rename this variable.";

    @Override
    List<String> illegalNames() {
        return ImmutableList.of((Object)"undefined");
    }

    @Override
    String getMessage(Symbol symbol) {
        return MESSAGE;
    }

    @Override
    public void visitScript(ScriptTree tree) {
        for (Symbol symbol : this.getIllegalSymbols()) {
            if (symbol.scope().isGlobal() || !symbol.isVariable()) continue;
            this.raiseIssuesOnDeclarations(symbol, MESSAGE);
        }
    }
}

