/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.BracketMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S4030")
public class UnusedCollectionCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Either use this collection's contents or remove the collection.";
    private static final Set<String> COLLECTION_CONSTRUCTORS = ImmutableSet.of((Object)"Array", (Object)"Set", (Object)"Map", (Object)"WeakSet", (Object)"WeakMap");
    private static final Set<String> WRITING_METHODS = ImmutableSet.of((Object)"copyWithin", (Object)"fill", (Object)"pop", (Object)"push", (Object)"reverse", (Object)"shift", (Object[])new String[]{"sort", "splice", "unshift", "clear", "delete", "set", "add"});
    private static final EnumSet<Symbol.Kind> VARIABLE_SYMBOL_KINDS = EnumSet.of(Symbol.Kind.VARIABLE, Symbol.Kind.LET_VARIABLE, Symbol.Kind.CONST_VARIABLE);

    public void visitScript(ScriptTree tree) {
        Set symbols = this.getContext().getSymbolModel().getSymbols();
        symbols.forEach(symbol -> {
            if (symbol.usages().size() < 2 || !VARIABLE_SYMBOL_KINDS.contains(symbol.kind())) {
                return;
            }
            Usage declaration = UnusedCollectionCheck.getDeclarationUsage(symbol);
            if (declaration == null) {
                return;
            }
            for (Usage usage : symbol.usages()) {
                if (!(usage.isDeclaration() ? UnusedCollectionCheck.isInitializedToNotCollection(usage) : !UnusedCollectionCheck.isCollectionWrite(usage))) continue;
                return;
            }
            this.addIssue((Tree)declaration.identifierTree(), MESSAGE);
        });
    }

    private static boolean isInitializedToNotCollection(Usage usage) {
        IdentifierTree identifier = usage.identifierTree();
        Tree ancestor = CheckUtils.getFirstAncestor((Tree)identifier, new Kinds[]{Tree.Kind.INITIALIZED_BINDING_ELEMENT, Tree.Kind.VAR_DECLARATION, Tree.Kind.LET_DECLARATION, Tree.Kind.CONST_DECLARATION, Tree.Kind.SCRIPT});
        if (ancestor.is(new Kinds[]{Tree.Kind.INITIALIZED_BINDING_ELEMENT})) {
            return !UnusedCollectionCheck.isNewCollectionCreation(((InitializedBindingElementTree)ancestor).right());
        }
        if (ancestor.is(new Kinds[]{Tree.Kind.SCRIPT})) {
            return true;
        }
        return ancestor.parent().is(new Kinds[]{Tree.Kind.FOR_OF_STATEMENT, Tree.Kind.FOR_IN_STATEMENT});
    }

    private static boolean isCollectionWrite(Usage usage) {
        ExpressionStatementTree expressionStatement = (ExpressionStatementTree)CheckUtils.getFirstAncestor((Tree)usage.identifierTree(), new Kinds[]{Tree.Kind.EXPRESSION_STATEMENT});
        if (expressionStatement != null) {
            return UnusedCollectionCheck.isElementWrite(expressionStatement, usage) || UnusedCollectionCheck.isWritingMethodCall(expressionStatement, usage) || UnusedCollectionCheck.isVariableWrite(expressionStatement, usage);
        }
        return false;
    }

    private static boolean isElementWrite(ExpressionStatementTree statement, Usage usage) {
        ExpressionTree variable;
        if (statement.expression().is(new Kinds[]{KindSet.ASSIGNMENT_KINDS}) && (variable = ((AssignmentExpressionTree)statement.expression()).variable()).is(new Kinds[]{Tree.Kind.BRACKET_MEMBER_EXPRESSION})) {
            return ((BracketMemberExpressionTree)variable).object() == usage.identifierTree();
        }
        return false;
    }

    private static boolean isWritingMethodCall(ExpressionStatementTree statement, Usage usage) {
        ExpressionTree callee;
        if (statement.expression().is(new Kinds[]{Tree.Kind.CALL_EXPRESSION}) && (callee = ((CallExpressionTree)statement.expression()).callee()).is(new Kinds[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            DotMemberExpressionTree memberExpression = (DotMemberExpressionTree)callee;
            return memberExpression.object() == usage.identifierTree() && WRITING_METHODS.contains(memberExpression.property().name());
        }
        return false;
    }

    private static boolean isVariableWrite(ExpressionStatementTree statement, Usage usage) {
        if (statement.expression().is(new Kinds[]{Tree.Kind.ASSIGNMENT})) {
            AssignmentExpressionTree assignment = (AssignmentExpressionTree)statement.expression();
            return assignment.variable() == usage.identifierTree() && UnusedCollectionCheck.isNewCollectionCreation(assignment.expression());
        }
        return false;
    }

    private static boolean isNewCollectionCreation(ExpressionTree expression) {
        if (expression.is(new Kinds[]{Tree.Kind.ARRAY_LITERAL})) {
            return true;
        }
        if (expression.is(new Kinds[]{Tree.Kind.CALL_EXPRESSION})) {
            return UnusedCollectionCheck.isCollectionConstructor(((CallExpressionTree)expression).callee());
        }
        if (expression.is(new Kinds[]{Tree.Kind.NEW_EXPRESSION})) {
            return UnusedCollectionCheck.isCollectionConstructor(((NewExpressionTree)expression).expression());
        }
        return false;
    }

    private static boolean isCollectionConstructor(ExpressionTree callee) {
        return callee.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE}) && COLLECTION_CONSTRUCTORS.contains(((IdentifierTree)callee).identifierToken().text());
    }

    @Nullable
    private static Usage getDeclarationUsage(Symbol symbol) {
        for (Usage usage : symbol.usages()) {
            if (!usage.isDeclaration()) continue;
            return usage;
        }
        return null;
    }
}

