/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ArgumentListTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S1154")
public class UselessStringOperationCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "%s is an immutable object; you must either store or return the result of the operation.";

    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.of((Object)Tree.Kind.EXPRESSION_STATEMENT);
    }

    public void visitNode(Tree tree) {
        DotMemberExpressionTree memberExpression;
        ExpressionTree callee;
        Tree expression = ((ExpressionStatementTree)tree).expression();
        if (expression.is(new Kinds[]{Tree.Kind.CALL_EXPRESSION}) && (callee = ((CallExpressionTree)expression).callee()).is(new Kinds[]{Tree.Kind.DOT_MEMBER_EXPRESSION}) && (memberExpression = (DotMemberExpressionTree)callee).object().types().containsOnly(Type.Kind.STRING) && !UselessStringOperationCheck.isReplaceExclusion(memberExpression.property(), ((CallExpressionTree)expression).argumentClause())) {
            this.addIssue((Tree)memberExpression.property(), String.format(MESSAGE, UselessStringOperationCheck.getVariable((MemberExpressionTree)memberExpression)));
        }
    }

    private static boolean isReplaceExclusion(IdentifierTree property, ArgumentListTree arguments) {
        if ("replace".equals(property.name()) && arguments.arguments().size() == 2) {
            Tree secondArgument = (Tree)arguments.arguments().get(1);
            return !((ExpressionTree)secondArgument).types().containsOnly(Type.Kind.STRING);
        }
        return false;
    }

    private static String getVariable(MemberExpressionTree memberExpression) {
        String variableName = CheckUtils.asString((Tree)memberExpression.object());
        if (variableName.length() > 30) {
            variableName = "String";
        }
        return variableName;
    }
}

