/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S3735")
public class VoidUseCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Remove \"void\" operator";

    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.of((Object)Tree.Kind.VOID);
    }

    public void visitNode(Tree tree) {
        UnaryExpressionTree voidExpression = (UnaryExpressionTree)tree;
        ExpressionTree operand = CheckUtils.removeParenthesis(voidExpression.expression());
        if (!VoidUseCheck.isZero(operand)) {
            this.addIssue((Tree)voidExpression.operatorToken(), MESSAGE);
        }
    }

    private static boolean isZero(ExpressionTree expression) {
        return expression.is(new Kinds[]{Tree.Kind.NUMERIC_LITERAL}) && "0".equals(((LiteralTree)expression).value());
    }
}

