/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S2685")
public class ArgumentsCallerCalleeUsageCheck
extends SubscriptionVisitorCheck {
    private static final String ARGUMENTS = "arguments";
    private static final String CALLER = "caller";
    private static final String CALLEE = "callee";
    LinkedList<String> scope = Lists.newLinkedList();

    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.builder().add((Object)Tree.Kind.DOT_MEMBER_EXPRESSION).addAll((Iterable)KindSet.FUNCTION_KINDS.getSubKinds()).build();
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Kinds[]{KindSet.FUNCTION_KINDS})) {
            Tree name = ((FunctionTree)tree).name();
            if (name != null) {
                this.scope.add(CheckUtils.asString(name));
            }
        } else {
            this.checkExpression((DotMemberExpressionTree)tree);
        }
    }

    private void checkExpression(DotMemberExpressionTree expression) {
        if (!expression.object().is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE}) || !expression.property().is(new Kinds[]{Tree.Kind.PROPERTY_IDENTIFIER})) {
            return;
        }
        String object = ((IdentifierTree)expression.object()).name();
        String property = expression.property().name();
        if (ARGUMENTS.equals(object)) {
            this.checkArgumentsProperty((Tree)expression, property);
        } else if (this.scope.contains(object)) {
            this.checkFunctionsProperty((Tree)expression, object, property);
        }
    }

    private void checkFunctionsProperty(Tree tree, String object, String property) {
        if (CALLER.equals(property)) {
            this.addIssue(tree, "Remove this use of \"" + object + ".caller\".");
        } else if (ARGUMENTS.equals(property)) {
            this.addIssue(tree, "Remove this use of \"" + object + ".arguments\".");
        }
    }

    private void checkArgumentsProperty(Tree tree, String property) {
        if (CALLER.equals(property)) {
            this.addIssue(tree, "Remove this use of \"arguments.caller\".");
        } else if (CALLEE.equals(property)) {
            this.addIssue(tree, "Name the enclosing function instead of using the deprecated property \"arguments.callee\".");
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Kinds[]{KindSet.FUNCTION_KINDS}) && ((FunctionTree)tree).name() != null) {
            this.scope.removeLast();
        }
    }
}

