/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="AssignmentWithinCondition")
public class AssignmentWithinConditionCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Extract the assignment of \"%s\" from this expression.";
    private static final Kinds[] ALLOWED_PARENT_KINDS = new Kinds[]{KindSet.LOOP_KINDS, KindSet.EQUALITY_KINDS, KindSet.COMPARISON_KINDS, Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.ARROW_FUNCTION};
    private static final Kinds[] ALLOWED_PARENT_KINDS_WITH_INITIALIZER = new Kinds[]{KindSet.LOOP_KINDS, KindSet.EQUALITY_KINDS, KindSet.COMPARISON_KINDS, Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.ARROW_FUNCTION, Tree.Kind.INITIALIZED_BINDING_ELEMENT};

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        Tree parent = tree.parent();
        if (parent.is(new Kinds[]{Tree.Kind.PARENTHESISED_EXPRESSION}) && parent.parent().is(new Kinds[]{Tree.Kind.EXPRESSION_STATEMENT}) && !tree.variable().is(new Kinds[]{Tree.Kind.OBJECT_ASSIGNMENT_PATTERN})) {
            this.addIssue(tree);
        } else {
            Tree parentIgnoreParenthesesAndComma = AssignmentWithinConditionCheck.parentIgnoreParenthesesAndComma((Tree)tree);
            Tree parentIgnoreAssignment = AssignmentWithinConditionCheck.parentIgnoreAssignment((Tree)tree);
            if (!parentIgnoreParenthesesAndComma.is(ALLOWED_PARENT_KINDS) && !parentIgnoreAssignment.is(ALLOWED_PARENT_KINDS_WITH_INITIALIZER)) {
                this.addIssue(tree);
            }
        }
        super.visitAssignmentExpression(tree);
    }

    private void addIssue(AssignmentExpressionTree tree) {
        this.addIssue((Tree)tree.operatorToken(), String.format(MESSAGE, CheckUtils.asString((Tree)tree.variable())));
    }

    private static Tree parentIgnoreParenthesesAndComma(Tree tree) {
        Tree parent = tree.parent();
        if (parent.is(new Kinds[]{Tree.Kind.PARENTHESISED_EXPRESSION, Tree.Kind.COMMA_OPERATOR})) {
            return AssignmentWithinConditionCheck.parentIgnoreParenthesesAndComma(parent);
        }
        return parent;
    }

    private static Tree parentIgnoreAssignment(Tree tree) {
        Tree parent = tree.parent();
        if (parent.is(new Kinds[]{Tree.Kind.ASSIGNMENT})) {
            return AssignmentWithinConditionCheck.parentIgnoreAssignment(parent);
        }
        return parent;
    }
}

