/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.ClassTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S101")
public class ClassNameCheck
extends DoubleDispatchVisitorCheck {
    private static final String DEFAULT_FORMAT = "^[A-Z][a-zA-Z0-9]*$";
    @RuleProperty(key="format", description="Regular expression used to check the class names against.", defaultValue="^[A-Z][a-zA-Z0-9]*$")
    public String format = "^[A-Z][a-zA-Z0-9]*$";

    public void visitClass(ClassTree tree) {
        String name;
        IdentifierTree className;
        if (tree.is(new Kinds[]{Tree.Kind.CLASS_DECLARATION}) && (className = tree.name()) != null && !(name = className.name()).matches(this.format)) {
            this.addIssue((Tree)className, String.format("Rename class \"%s\" to match the regular expression %s.", name, this.format));
        }
        super.visitClass(tree);
    }
}

