/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.cfg.CfgBlock;
import org.sonar.javascript.cfg.CfgBranchingBlock;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.se.LiveVariableAnalysis;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.AccessorMethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrayLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S1854")
public class DeadStoreCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove this useless assignment to local variable \"%s\"";
    private static final Set<String> BASIC_LITERAL_VALUES = ImmutableSet.of((Object)"true", (Object)"false", (Object)"1", (Object)"0", (Object)"-1", (Object)"null", (Object[])new String[]{"''", "\"\""});

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.checkFunction((FunctionTree)tree);
        super.visitFunctionDeclaration(tree);
    }

    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.checkFunction((FunctionTree)tree);
        super.visitFunctionExpression(tree);
    }

    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.checkFunction((FunctionTree)tree);
        super.visitMethodDeclaration(tree);
    }

    public void visitAccessorMethodDeclaration(AccessorMethodDeclarationTree tree) {
        this.checkFunction((FunctionTree)tree);
        super.visitAccessorMethodDeclaration(tree);
    }

    public void visitArrowFunction(ArrowFunctionTree tree) {
        this.checkFunction((FunctionTree)tree);
        super.visitArrowFunction(tree);
    }

    private void checkFunction(FunctionTree functionTree) {
        if (!functionTree.body().is(new Kinds[]{Tree.Kind.BLOCK})) {
            return;
        }
        this.checkCFG(ControlFlowGraph.build((BlockTree)((BlockTree)functionTree.body())), functionTree);
    }

    private void checkCFG(ControlFlowGraph cfg, FunctionTree functionTree) {
        for (CfgBlock cfgBlock : cfg.blocks()) {
            if (!DeadStoreCheck.isTryBlock(cfgBlock)) continue;
            return;
        }
        Scope scope = this.getContext().getSymbolModel().getScope((Tree)functionTree);
        LiveVariableAnalysis lva = LiveVariableAnalysis.create((ControlFlowGraph)cfg, (Scope)scope);
        LiveVariableAnalysis.Usages usages = lva.getUsages();
        for (CfgBlock cfgBlock : cfg.blocks()) {
            Set live = lva.getLiveOutSymbols(cfgBlock);
            for (Tree element : Lists.reverse((List)cfgBlock.elements())) {
                Usage usage = usages.getUsage(element);
                if (usage == null) continue;
                this.checkUsage(usage, live, usages);
            }
        }
        this.raiseIssuesForNeverReadSymbols(usages);
    }

    private static boolean isTryBlock(CfgBlock block) {
        if (block instanceof CfgBranchingBlock) {
            CfgBranchingBlock branchingBlock = (CfgBranchingBlock)block;
            return branchingBlock.branchingTree().is(new Kinds[]{Tree.Kind.TRY_STATEMENT});
        }
        return false;
    }

    private void checkUsage(Usage usage, Set<Symbol> liveSymbols, LiveVariableAnalysis.Usages usages) {
        Symbol symbol = usage.symbol();
        if (usage.isWrite()) {
            if (!(liveSymbols.contains(symbol) || usages.hasUsagesInNestedFunctions(symbol) || usages.neverReadSymbols().contains(symbol) || DeadStoreCheck.initializedToBasicValue(usage))) {
                this.addIssue((Tree)usage.identifierTree(), symbol);
            }
            liveSymbols.remove(symbol);
        }
        if (usage.isRead()) {
            liveSymbols.add(symbol);
        }
    }

    private static boolean initializedToBasicValue(Usage usage) {
        if (usage.isDeclaration()) {
            Tree parent = usage.identifierTree().parent();
            if (parent.is(new Kinds[]{Tree.Kind.INITIALIZED_BINDING_ELEMENT})) {
                ExpressionTree expression = ((InitializedBindingElementTree)parent).right();
                return DeadStoreCheck.isBasicValue(expression);
            }
        }
        return false;
    }

    private static boolean isBasicValue(ExpressionTree expression) {
        if (expression.is(new Kinds[]{Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.NUMERIC_LITERAL, Tree.Kind.STRING_LITERAL, Tree.Kind.NULL_LITERAL})) {
            return BASIC_LITERAL_VALUES.contains(((LiteralTree)expression).value());
        }
        if (expression.is(new Kinds[]{Tree.Kind.UNARY_MINUS})) {
            ExpressionTree operand = ((UnaryExpressionTree)expression).expression();
            return BASIC_LITERAL_VALUES.contains("-" + ((LiteralTree)operand).value());
        }
        if (expression.is(new Kinds[]{Tree.Kind.ARRAY_LITERAL})) {
            return ((ArrayLiteralTree)expression).elements().isEmpty();
        }
        if (expression.is(new Kinds[]{Tree.Kind.OBJECT_LITERAL})) {
            return ((ObjectLiteralTree)expression).properties().isEmpty();
        }
        if (expression.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
            return ((IdentifierTree)expression).name().equals("undefined");
        }
        ExpressionTree withoutParenthesis = CheckUtils.removeParenthesis(expression);
        if (withoutParenthesis.is(new Kinds[]{Tree.Kind.VOID})) {
            ExpressionTree operand = ((UnaryExpressionTree)withoutParenthesis).expression();
            return operand.is(new Kinds[]{Tree.Kind.NUMERIC_LITERAL}) && "0".equals(((LiteralTree)operand).value());
        }
        return false;
    }

    private void raiseIssuesForNeverReadSymbols(LiveVariableAnalysis.Usages usages) {
        for (Symbol symbol : usages.neverReadSymbols()) {
            for (Usage usage : symbol.usages()) {
                if (!usage.isWrite() || DeadStoreCheck.initializedToBasicValue(usage)) continue;
                this.addIssue((Tree)usage.identifierTree(), symbol);
            }
        }
    }

    private void addIssue(Tree element, Symbol symbol) {
        this.addIssue(element, String.format(MESSAGE, symbol.name()));
    }
}

